<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\LogOptions;

class Aggregator extends Model
{
    use LogsActivity;

    protected $table = 'aggregators';
    protected $fillable = [
        'company_name',
        'supply_items',
        'unit_cost',
        'cons_day',
        'address',
        'state',
        'phone',
        'email',
        'bank',
        'bvn',
        'account_no',
        'tin',
        'feed_pupils',
        'amount_to_paid_cook',
        'program_manager_id',
        'is_verified',
        'is_active',
        'status',
        'expired_at',
        'week_cost',
        'amount_twenty',
        'weekly_comsp'
    ];

    protected static $logAttributes = ['*'];
    
    protected static $logName = 'Aggregators';

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logAll()
            ->useLogName('Aggregators');
    }

    public function getDescriptionForEvent(string $eventName): string
    {
        return "Aggregators has been {$eventName}.";
    }

    public static function get_name($id)
    {
        return Aggregator::find($id)->company_name;
    }
    
    public static function get_state_name($id){
        return State::where('id', $id)->value('name');
    }
}
