<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\LogOptions;

class Cooks extends Model
{
    use LogsActivity;

    protected $table = 'cooks';

    protected $fillable = [
        'user_id',
        'first_name',
        'middle_name',
        'last_name',
        'gender',
        'dob',
        'account_number',
        'bank_name',
        'bvn',
        'phone',
        'email',
        'city',
        'state',
        'lga',
        'photo',
        'school_id',
        'students',
        'amount_of_feed_per_pupil',
        'is_active',
        'status',
        'expired_at',
    ];

    protected static $logAttributes = ['*'];
    
    protected static $logName = 'Cooks';

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logAll()
            ->useLogName('Cooks');
    }

    public function getDescriptionForEvent(string $eventName): string
    {
        return "Cooks has been {$eventName}.";
    }

    public function getPhotoAttribute($value)
    {
        if ($value) {
            return asset('uploads/' . $value);
        } else {
            return asset('backend/dist/img/avatar.png');
        }
    }

    public function school()
    {
        return $this->hasOne(School::class, 'id', 'school_id');
    }

    public function getFullNameAttribute()
    {
        return $this->first_name . ' ' . $this->middle_name . ' ' . $this->last_name;
    }

    public static function get_name($id)
    {
        $cooks = Cooks::find($id);
        return $cooks->first_name . ' ' . $cooks->middle_name . ' ' . $cooks->last_name;
    }
}
