<?php
namespace App\Http\Controllers;

use App\Notifications\AgendamentoPendente;
use App\Aggregator;
use App\Cooks;
use App\Feeding;
use App\Post;
use App\School;
use App\User;
use App\State;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use DateTime;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Notifications\NewChatNotification;
use Notifications;

class ChatController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        //        $this->middleware(['auth','verified']);
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index(Request $request)
    {
        $this->middleware(['auth', 'verified']);
        if (!Auth::check()) {            
            return redirect('/');
        }

        $id = Auth::user()->id; // current user id
        $user = User::find($id);
        $roleObject = $user->roles;
        $user_type = $roleObject[0]->name;
        $input = $request->all();
        // chat data between users
        if ($input) {
            $reciverId = $input['reciverId'];
        } else {
            $reciverId = "";
        }

        if ($reciverId != "") {

            $sql = "SELECT cm.message, c.sender_user_id, c.receiver_user_id,cm.seen,u.photo,u.name,u.user_type,cm.created_at
                FROM chats c
                JOIN chat_messages cm ON c.id = cm.chat_id
                JOIN users u ON u.id = cm.user_id
                WHERE (c.sender_user_id = $id AND c.receiver_user_id = $reciverId)
                OR (c.sender_user_id = $reciverId AND c.receiver_user_id = $id)";

            $chatData = DB::select($sql);
            $chatCount = count($chatData);
            $sqlReciver = "select * from users where id =" . $reciverId;
            $ReciverData = DB::select($sqlReciver);

        } else {
            $chatCount = 0;
            $chatData = [];
            $ReciverData = [];
        }
        $adminRole = "Admin";
        $state_admins = User::whereHas('roles', function ($q) use ($adminRole) {
            $q->where('name', '=', $adminRole);
        })->get();
        $userRole = "Program Manager";
        $data = User::whereHas('roles', function ($q) use ($userRole) {
            $q->where('name', '=', $userRole);
        })->get();

        return view('chat.index', compact('data', 'chatData', 'id', 'reciverId', 'ReciverData', 'chatCount', 'state_admins'));

    }
    public function createChat(Request $request)
    {
        $input = $request->all();
        $senderId = $input['senderId'];
        $reciverId = $input['reciverId'];
        $msg = $input['msg'];
        if ($msg != "") {
            $id = DB::table('chats')->insertGetId(
                array(
                    'sender_user_id' => $senderId,
                    'receiver_user_id' => $reciverId
                )
            );
            if ($id > 0 and $msg != "") {
                $chat_message_id = DB::table('chat_messages')->insertGetId(
                    array(
                        'chat_id' => $id,
                        'user_id' => $senderId,
                        'message' => $msg

                    )
                );
            } else {
                $chat_message_id = 0;
            }
        }

        // notify the user that he gor a messege
        $senderData = User::find($senderId);
        $reciverData = User::find($reciverId);
        // $senderName = $senderData->name;
        // $reciverName = $reciverData->name;

        $id = Auth::user()->id; // current user id
        $user = User::find($id);
        $roleObject = $user->roles;
        $user_type = $roleObject[0]->name;
        // if ($user_type == "Admin") {
        $data = User::orderBy('id', 'DESC')->get();
        $input = $request->all();
        // chat data between users


        if ($input) {
            $reciverId = $input['reciverId'];
        } else {
            $reciverId = "";
        }

        if ($reciverId != "") {

            $sql = "SELECT cm.message, c.sender_user_id, c.receiver_user_id,cm.seen,u.photo,u.name,u.user_type,cm.created_at
                FROM chats c
                JOIN chat_messages cm ON c.id = cm.chat_id
                JOIN users u ON u.id = cm.user_id
                WHERE (c.sender_user_id = $id AND c.receiver_user_id = $reciverId)
                OR (c.sender_user_id = $reciverId AND c.receiver_user_id = $id)";

            $chatData = DB::select($sql);
            $chatCount = count($chatData);
            $sqlReciver = "select * from users where id =" . $reciverId;
            $ReciverData = DB::select($sqlReciver);
        
        } else {
            $chatCount = 0;
            $chatData = [];
            $ReciverData = [];
        }
        $adminRole = "Admin";
        $state_admins = User::whereHas('roles', function ($q) use ($adminRole) {
            $q->where('name', '=', $adminRole);
        })->get();

        $userRole = "Program Manager";
        $data = User::whereHas('roles', function ($q) use ($userRole) {
            $q->where('name', '=', $userRole);
        })->get();
        $dataArray = array();
        $dataArray['data'] = $data;
        $dataArray['chatData'] = $chatData;
        $dataArray['id'] = $id;
        $dataArray['reciverId'] = $reciverId;
        $dataArray['ReciverData'] = $ReciverData;
        $dataArray['chatCount'] = $chatCount;
        $dataArray['state_admins'] = $state_admins;
        $userSchema = User::first();

        // print_r($chatData);
        if (auth()->user() and $msg != "") {

            $reciverUser = User::where('id', $reciverId)->first();
            $senderUser = User::where('id', $id)->first();
            $senderUserName = $senderUser->name;
            $reciverUserName = $reciverUser->name;
            $message = "Hey " . $reciverUserName . ", you a new chat messege from " . $senderUserName;
            $reciverUser->notify(new NewChatNotification($message));
        }
        // dd("notification saved");
        // return view('chat.index');
        // print_r($dataArray);
        return $dataArray;

    }

    public function sendNotification()
    {
        $userSchema = User::first();

        $message = 'New Pupils Added, Payment Status ';
        $user = User::where('id', 16)->first();
        print_r($user->name);

        $user->notify(new NewChatNotification($message));
        dd('Task completed!');

    }
}