<?php

namespace App\Http\Controllers;

use App\Aggregator;
use App\Cooks;
use App\Feeding;
use App\Post;
use App\School;
use App\User;
use App\State;
use Carbon\Carbon;
use DateTime;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        //        $this->middleware(['auth','verified']);
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function home()
    {

        $this->middleware(['auth', 'verified']);
        if (!Auth::check()) {            
            return redirect('/');
        }

        
        $current_month = Carbon::now()->month;
        $manager_id = Auth::user()->id;
        $state_name = Auth::user()->state;
        $state = State::where('name', $state_name)->first();
        $total_cooks = Cooks::count();


        if (auth()->user()->hasRole('Admin')) {
            $this_month_unit_cost = Feeding::whereMonth('created_at', $current_month)->sum('unit_cost');
            $this_month_paid_cost = Feeding::whereMonth('created_at', $current_month)->sum('paid');
            $this_month_pupils = Feeding::whereMonth('created_at', $current_month)->sum('pupils');
            
            $total_aggregators = Aggregator::count();
            $total_cooks = Cooks::count();
            $pupils = School::all()->sum('students');
            $total_schools = School::count();
            $total_suspended_cooks =  DB::table('cooks AS t1')
            ->where('t1.is_active','=','0')
                ->count();
            $total_active_cooks = DB::table('cooks AS t1')
                ->where('t1.is_active','=','1')
                ->count();
            $State = State::paginate(50);
            $StateUnique = $State->unique('id');
            
            
            $state_pupiles =DB::table('schools as t1')
                ->rightJoin('states as t2', 't1.state', '=', 't2.id')
                ->select('t2.name as state_name', DB::raw('SUM(t1.students) as user_count'))
                ->groupBy('t2.name')
                ->orderBy('t2.name')
                ->get();

            $state_wise_active_cooks = DB::table('cooks AS t1')
                ->rightJoin('states AS t2', 't1.state', '=', 't2.id')
                ->select('t2.name as state_name', 't1.status as status', DB::raw('count(t1.state) AS user_count'))
                ->where('t1.is_active','=','1')
                
                ->groupBy('t2.name')
                ->orderBy('t2.name')
                ->get();
            
            $state_wise_in_active_cooks =  DB::table('cooks AS t1')
                ->rightJoin('states AS t2', 't1.state', '=', 't2.id')
                ->select('t2.name as state_name', 't1.status as status', DB::raw('count(t1.state) AS user_count'))
                ->where('t1.is_active','=','0')
                ->groupBy('t2.name')
                ->orderBy('t2.name')
                ->get();
            $listing_title = "States";
            
        } else {
            $this_month_unit_cost = Feeding::whereMonth('created_at', $current_month)->where('manager_id', $manager_id)->sum('unit_cost');
            $this_month_paid_cost = Feeding::whereMonth('created_at', $current_month)->where('manager_id', $manager_id)->sum('paid');
            $this_month_pupils = Feeding::whereMonth('created_at', $current_month)->where('manager_id', $manager_id)->sum('pupils');
            
            $total_aggregators = Aggregator::where('state', $state->id)->count();
            $total_cooks = Cooks::where('state', $state->id)->count();
            $pupils = School::where('state', $state->id)->sum('students');
            $total_schools = School::where('state', $state->id)->count();
            $total_suspended_cooks =  DB::table('cooks AS t1')
                ->where('t1.is_active','=','0')
                ->where('t1.state','=','$state->id')
                ->where('t1.state','=', $state->id)
                ->count();
            $total_active_cooks = DB::table('cooks AS t1')
                ->where('t1.is_active','=','1')
                ->where('t1.state','=', $state->id)
                ->count();
           
            
            
            $State = School::paginate(50);
            $StateUnique = $State->unique('state');
            $state_pupiles =DB::table('schools as t1')
                ->rightJoin('local_governments as t2', 't1.lga', '=', 't2.name')
                ->select('t2.name as state_name', DB::raw('SUM(t1.students) as user_count'))
                ->where('t1.state','=', $state->id)
                ->groupBy('t2.name')
                ->orderBy('t2.name')

                ->get();
            $state_wise_active_cooks = DB::table('cooks AS t1')
                ->rightJoin('local_governments AS t2', 't1.lga', '=', 't2.name')
                ->select('t2.name as state_name', 't1.status as status', DB::raw('count(t1.state) AS user_count'))
                ->where('t1.status','=','Approved')
                ->where('t1.state','=', $state->id)
                ->groupBy('t2.name')
                ->orderBy('t2.name')
                ->get();
            
            $state_wise_in_active_cooks =  DB::table('cooks AS t1')
                ->rightJoin('local_governments AS t2', 't1.lga', '=', 't2.name')
                ->select('t2.name as state_name', 't1.status as status', DB::raw('count(t1.lga) AS user_count'))
                ->where('t1.status','=','Cancel')
                ->where('t1.state','=', $state->id)
                ->groupBy('t2.name')
                ->orderBy('t2.name')
                ->get();
                    
                $listing_title = "LGA";
                
               
            }

        $total_state_admin = User::whereHas('roles', function ($q) {
            $q->where('name', '=', 'State-Manager');
        })->count();
    
        $test = "testing data";
        $total_pupils_request = Feeding::where('status', '=', 'Requested')->count();
        $userId = Auth::id();
        $user = User::findOrFail($userId);
        $today = Carbon::now()->toDateString();

        return view('home.dashboard', compact('this_month_unit_cost', 'total_state_admin', 'StateUnique', 'this_month_paid_cost', 'this_month_pupils', 'total_cooks', 'total_aggregators', 'total_schools', 'total_pupils_request', 'user', 'today', 'pupils', 'state_pupiles', 'state_wise_active_cooks', 'state_wise_in_active_cooks','total_suspended_cooks','total_active_cooks','listing_title'));
    }


    public function index()
    {

        $slider_posts = Post::where('post_type', '=', 'slider')->limit(5)->get();
        $blogs = Post::where('status', '=', 'published')->orderBy('id', 'DESC')->limit(21)->get();

        // return view('home', compact('blogs', 'slider_posts'));
        return view('welcome', compact('blogs', 'slider_posts'));
    }
}
