<?php

namespace App\Http\Controllers;

use App\Cooks;
use App\Aggregator;
use App\Payment;
use App\PaymentStatus;
use App\School;
use App\State;
use App\User;
use App\Withdraw;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\Validator;
use App\Imports\PaymentImport;
use DB;

class PaymentController extends Controller
{
    public function index(Request $request)
    {
        date_default_timezone_set("Africa/Lagos");
        $count = Payment::whereYear('created_at', Carbon::now()->year)->whereMonth('created_at', Carbon::now()->month)->where('manager_id', Auth::id())->count();
        if ($count <= 20) {
            $show = 0;
        } else {
            $show = 1;
        }
        $id = Auth::user()->id;
        $user = User::find($id);
        $roleObject = $user->roles;
        $user_type = $roleObject[0]->name;

        // if (Auth::user()->user_type == "Admin") {
        if ($user_type == "Admin") {
            // if (Auth::user()->user_type == "Admin") {
            //$data = Payment::where('withdraw',0)->orderBy('id', 'DESC')->get();
            $data = DB::select("select payments.id as id, aggregators.company_name, users.state,
                        SUM(cook_amount) as sumcook,
                        SUM(aggregator_amount) as sumaggregator,
                        SUM(total_cook_amount) as totalcook,
                        SUM(total_aggregator_amount) as totalaggregator,
                        SUM(total_amount) as total, payments.*
                        FROM payments
                        inner join `aggregators` on `payments`.`total_aggregator` = `aggregators`.`id`
                        inner join `users` ON payments.manager_id = users.id
                        where `withdraw` = 0 GROUP BY payments.month order by payments.id desc;");
            $can_withdraw = 1;
            $show = 1;
            $state = 1;
            $total_cook = 1;
            $total_pupils = 1;
        } else {
            $monthName = date("F", mktime(0, 0, 0, Carbon::now()->subMonth()->month, 10));
            $count = Payment::whereYear('created_at', '=', Carbon::now()->subMonth()->year)->where('month', '=', $monthName)->where('withdraw', '=', 0)->count();
            if ($count > 0) {
                $can_withdraw = 1; //Withdraw::whereYear('created_at', Carbon::now()->year)->whereMonth('created_at', Carbon::now()->month)->where('manager_id',Auth::id())->count();
            } else {
                $can_withdraw = 0;
            }

            //$data = Payment::where('withdraw',0)->where('manager_id',Auth::id())->orderBy('id', 'DESC')->get();
            $data = DB::select("select payments.id as id, aggregators.company_name, 
                        SUM(cook_amount) as sumcook,  
                        SUM(aggregator_amount) as sumaggregator,
                        SUM(total_cook_amount) as totalcook,
                        SUM(total_aggregator_amount) as totalaggregator,
                        SUM(total_amount) as total, payments.* 
                        FROM payments 
                        LEFT join `aggregators` on `payments`.`total_aggregator` = `aggregators`.`id`
                        where `withdraw` = 0 and `manager_id` = " . Auth::id() . " GROUP BY payments.month order by payments.id desc;");

            if (Auth::user()->state == null or Auth::user()->state == "") {
                return back()->with('error', 'You do not have any state assigned');
            }
            $state = State::where('name', '=', Auth::user()->state)->first();
            $total_cook = Cooks::where('state', '=', $state->id)->count();
            $total_pupils = School::where('state', '=', $state->id)->sum('students');
        }
        if ($request->has('id')) {
            $payment = Payment::find($request->id);
            $payment = Payment::where("month", $payment->month)->where("year", $payment->year)->orderBy('id', 'ASC')->get();

            $user = User::find($payment[0]->manager_id);
            $state = State::where('name', '=', $user->state)->first();
            $total_cook = $payment[0]->total_cook;
            $total_pupils = $payment[0]->total_pupils;
            $show = 0;
            $edit = 0;
        } else {
            $payment = [array(), array(), array(), array(), array()];
            $edit = 1;
        }

        /** list of aggregators **/
        if (auth()->user()->hasRole('Admin')) {
            $aggregators = Aggregator::where('is_active', true)->orderBy('id', 'desc')->paginate(50);
        } else {
            $state_name = Auth::user()->state;
            $state = State::where('name', $state_name)->first();

            //$aggregators  = Aggregator::where('is_active', true)->where('program_manager_id', Auth::user()->id)->orderBy('id', 'desc')->paginate(50);
            $aggregators = Aggregator::where('is_active', true)->where('state', $state->id)->orderBy('id', 'desc')->paginate(50);
        }

        return view('payment.index', compact('edit', 'payment', 'state', 'total_cook', 'data', 'show', 'total_pupils', 'can_withdraw', 'aggregators'));
    }
    public function create()
    {
        //
    }
    public function store(Request $request)
    {
        $this->validate($request, [
            'selectMonth' => 'required',
            'selectYear' => 'required',
        ]);

        /*date_default_timezone_set("Africa/Lagos");
        $day = Carbon::parse(now())->dayName;
        if ($day == "Saturday" || $day == "Sunday"){
        return back()->with('error','Today you are not allowed');
        }*/


        $data = $request->all();
        $data['manager_id'] = Auth::id();

        $errorflag = false;
        /** VALIDATION PART **/
        for ($i = 1; $i <= 5; $i++) {
            $sum = $data["aggregator_amount_$i"] + $data["cook_amount_$i"];
            if ($sum != 100) {
                $errorflag = true;
            }
        }
        if ($errorflag) {
            return back()->with('error', 'Sum of aggregator and cook amount must be 100');
        }
        /** END **/

        if (Payment::where('month', '=', $request->selectMonth)->where('year', $request->selectYear)->where('manager_id', Auth::id())->exists()) {
            // payment for this month already exists
            return back()->with('error', $request->selectMonth . ' ' . $request->selectYear . ' already exists');
        }


        $addData = array();
        $addData['manager_id'] = Auth::id();
        $addData['total_cook'] = $request->total_cook;
        $addData['total_pupils'] = $request["total_pupils"];
        $addData['year'] = $request->selectYear;
        $addData['month'] = $request->selectMonth;

        $dayarray = array(1 => 'Monday', 2 => 'Tuesday', 3 => 'Wednesday', 4 => 'Thursday', 5 => 'Friday');
        for ($i = 1; $i <= 5; $i++) {
            //calculating values
            if (is_array($request["total_aggregator_$i"])) {
                $request["total_aggregator_$i"] = implode(",", $request["total_aggregator_$i"]);
            }

            $addData['total_aggregator'] = $request["total_aggregator_$i"];
            $addData['cook_amount'] = $request["cook_amount_$i"] * 4;
            $addData['aggregator_amount'] = $request["aggregator_amount_$i"] * 4;
            $addData['total_cook_amount'] = $request->total_pupils * $request["cook_amount_$i"] * 4;
            $addData['total_aggregator_amount'] = $request->total_pupils * $request["aggregator_amount_$i"] * 4;
            $addData['total_amount'] = $addData['total_cook_amount'] + $addData['total_aggregator_amount'];
            $addData['day'] = $dayarray[$i];

            //Payment::updateOrCreate(['month' => $addData['month'], 'year'  => $addData['year'], 'day'  => $addData['day'], 'manager_id' => $addData['manager_id']], $addData);
            Payment::create($addData);
        }

        return back()->with('success', 'Amount added successfully');

        //         $sum = $data['aggregator_amount'] + $data['cook_amount'];
//         if ($sum == 70){
//             //calculating values
//             $data['total_cook_amount'] = $request->total_pupils * $request->cook_amount;
//             $data['total_aggregator_amount'] = $request->total_pupils * $request->aggregator_amount;
//             $data['total_amount'] = $data['total_cook_amount'] + $data['total_aggregator_amount'];
//             Payment::create($data);
//             return back()->with('success','Amount added successfully');

        //         }else{
//             return back()->with('error','Sum of aggregator and cook amount must be 70');
//         }
    }
    public function show(Payment $payment)
    {
        //
    }
    public function edit(Payment $payment)
    {
        //
    }
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'selectMonth' => 'required',
            'selectYear' => 'required',
        ]);


        $data = $request->all();
        $data['manager_id'] = Auth::id();

        $errorflag = false;
        /** VALIDATION PART **/
        for ($i = 1; $i <= 5; $i++) {
            $sum = $data["aggregator_amount_$i"] + $data["cook_amount_$i"];
            if ($sum != 100) {
                $errorflag = true;
            }
        }
        if ($errorflag) {
            return back()->with('error', 'Sum of aggregator and cook amount must be 100');
        }

        /** END **/

        $addData = array();
        $addData['manager_id'] = Auth::id();
        $addData['total_cook'] = $request->total_cook;
        $addData['total_pupils'] = $request["total_pupils"];
        $addData['year'] = $request->selectYear;
        $addData['month'] = $request->selectMonth;

        $dayarray = array(1 => 'Monday', 2 => 'Tuesday', 3 => 'Wednesday', 4 => 'Thursday', 5 => 'Friday');
        for ($i = 1; $i <= 5; $i++) {
            //calculating values
            $id = $request["itemId_$i"];
            $addData['total_aggregator'] = $request["total_aggregator_$i"];
            $addData['cook_amount'] = $request["cook_amount_$i"] * 4;
            $addData['aggregator_amount'] = $request["aggregator_amount_$i"] * 4;
            $addData['total_cook_amount'] = $request->total_pupils * $request["cook_amount_$i"] * 4;
            $addData['total_aggregator_amount'] = $request->total_pupils * $request["aggregator_amount_$i"] * 4;
            $addData['total_amount'] = $addData['total_cook_amount'] + $addData['total_aggregator_amount'];
            $addData['day'] = $dayarray[$i];

            //Payment::find($id)->update($addData);
            Payment::updateOrCreate(['month' => $addData['month'], 'year' => $addData['year'], 'day' => $addData['day'], 'manager_id' => $addData['manager_id']], $addData);
        }

        return back()->with('success', 'Amounts updated successfully');

        //         $data = $request->all();
//         $sum = $data['aggregator_amount'] + $data['cook_amount'];
//         if ($sum == 70){
//             //calculating values
//             $data['total_cook_amount'] = $request->total_pupils * $request->cook_amount;
//             $data['total_aggregator_amount'] = $request->total_pupils * $request->aggregator_amount;
//             $data['total_amount'] = $data['total_cook_amount'] + $data['total_aggregator_amount'];
//             Payment::find($id)->update($data);
//             return redirect()->route('payment.index')->with('success','Today Payment updated successfully');

        //         }else{
//             return back()->with('error','Sum of aggregator and cook amount must be 70');
//         }
    }
    public function destroy($id)
    {
        $payment = Payment::find($id);
        $payment = Payment::where("month", $payment->month)->where("year", $payment->year)->get();
        for ($i = 0; $i < count($payment); $i++) {
            Payment::find($payment[$i]['id'])->delete();
        }
        //return back()->with('success','Payment deleted successfully');
        return redirect()->to('payment');
    }

    public function paymentstatus(Request $request)
    {

        $state = isset($_REQUEST['filterstate']) ? $_REQUEST['filterstate'] : 25;
        $month = isset($_REQUEST['filterMonth']) ? $_REQUEST['filterMonth'] : date('F');
        $year = isset($_REQUEST['filterYear']) ? $_REQUEST['filterYear'] : date('Y');

        date_default_timezone_set("Africa/Lagos");
        $count = PaymentStatus::count();
        if ($count <= 20) {
            $show = 0;
        } else {
            $show = 1;
        }
        $id = Auth::user()->id;
        $user = User::find($id);
        $roleObject = $user->roles;
        $user_type = $roleObject[0]->name;

        // if (Auth::user()->user_type == "Admin") {
        if ($user_type == "Admin") {
            echo "admin";
            $isadmin = 1;
            $data = PaymentStatus::orderBy('id', 'DESC')->get();
            $data = DB::table('payment_status')
                ->join('states', 'payment_status.state', '=', 'states.id')
                ->get();
            // $data = DB::select("select states.name, payment_status.* from `payment_status` inner join `states` on `payment_status`.`state` = `states`.`id` 
            // where `state` = $state and `month` = '$month' and DATE_FORMAT(payment_status.created_at, '%Y') = '$year' order by payment_status.id desc;");
        } else {
            $isadmin = 0;
            $state_name = Auth::user()->state;
            $state = State::where('name', $state_name)->first();
            //$data = PaymentStatus::where('state', $state->id)->orderBy('id', 'DESC')->get();
            $data = DB::select("select states.name, payment_status.*  from `payment_status` inner join `states` on `payment_status`.`state` = `states`.`id`
                        where `state` = $state->id and `month` = '$month' and DATE_FORMAT(payment_status.created_at, '%Y') = '$year' order by payment_status.id desc;");
            if (Auth::user()->state == null or Auth::user()->state == "") {
                return back()->with('error', 'You do not have any state assigned');
            }
        }
        $statelist = State::get();

        return view('payment.paymentstatus', compact('data', 'isadmin', 'statelist', 'state', 'month', 'year'));
    }

    public function importPayment(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'select_file' => 'required|mimes:xls,xlsx',
            'importState' => 'required',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        Excel::import(new PaymentImport($request->importState), $request->file('select_file'));

        return redirect()->back()->with('success', 'Excel Data Imported successfully.');
    }

    public function editpaymentstatus(Request $request)
    {
        $status = $request->statusedit;

        if ($request->action == 'delete') {
            PaymentStatus::where('id', $request->id)->delete();
        } else {
            PaymentStatus::where('id', $request->id)->update(array('status' => $status));
        }

        $res = array();
        $res['done'] = true;
        $res['action'] = $request->action;
        $res['id'] = $request->id;

        echo json_encode($res);
    }
}