<?php

namespace App\Http\Controllers;

use App\Feeding;
use App\LocalGovernment;
use App\Notifications\NewFeedingNotification;
use App\PaymentReport;
use App\Report;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Spatie\Activitylog\Models\Activity;

class ReportController extends Controller
{
    public function state_gov($id)
    {
        $govs = LocalGovernment::where('state_id', '=', $id)->get();
        return view('state_gov', compact('govs', 'id'));
    }
    public function report(Request $request)
    {
        $data =  $this->validate($request, [
            'school_id' => 'required',
            'report' => 'required',
        ]);
        $report = Report::create($data);

        return back()->with(['type' => 'success', 'message' => 'School reported successfully']);
    }
    public function all_reports()
    {
        Report::where('seen', '=', 0)->update(['seen' => 1]);
        $reports = Report::with('school')->orderBy('id', 'DESC')->paginate(50);
        return view('reports.index', compact('reports'));
    }
    // get report making form
    public function report_form()
    {

        $user = Auth::user();

        if ($user->hasRole('Admin') == 'Admin') {
            $payment_requests = PaymentReport::orderBy('id', 'DESC')->limit(300)->get();
        } else {
            $payment_requests = PaymentReport::where('state_admin_id', Auth::id())->orderBy('id', 'DESC')->limit(100)->get();
        }

        return view('reports.report_form', compact('payment_requests'));
    }

    // date wise feeding report
    public function date_wise_feeding_report(Request $request)
    {
        $input = $request->all();
        $sDate = $input['sdate'];
        $eDate = $input['edate'];
        $status = $input['status'];
        $manager_id = Auth::user()->id;
        $id = 0;

        if (auth()->user()->hasRole('Admin')) {

            if ($sDate != null && $eDate != null) {
                $feedings = Feeding::whereDate('feeding_date', '>=', $sDate)
                    ->whereDate('feeding_date', '<=', $eDate)
                    ->orderBy('feeding_date', 'asc')
                    ->get();
            }
            if ($status != null || $status != '') {
                $feedings = Feeding::whereDate('feeding_date', '>=', $sDate)
                    ->whereDate('feeding_date', '<=', $eDate)
                    ->where('status', '=', $status)
                    ->orderBy('feeding_date', 'asc')
                    ->get();
            }
        } else {
            if ($sDate != null && $eDate != null) {
                $feedings = Feeding::whereDate('feeding_date', '>=', $sDate)
                    ->whereDate('feeding_date', '<=', $eDate)
                    ->where('manager_id', $manager_id)
                    ->orderBy('feeding_date', 'asc')
                    ->get();
            }
            if ($status != null || $status != '') {
                $feedings = Feeding::whereDate('feeding_date', '>=', $sDate)
                    ->whereDate('feeding_date', '<=', $eDate)
                    ->where('manager_id', $manager_id)
                    ->where('status', '=', $status)
                    ->orderBy('feeding_date', 'asc')
                    ->get();
            }
        }
        return view('reports.feeding_reports', compact('feedings', 'sDate', 'eDate', 'id'));
    }


    // state manager/admin feeding report request
    public function state_admin_feeding_report(Request $request)
    {
        $input = $request->all();
        $sDate = $input['sdate'];
        $eDate = $input['edate'];
        $status = $input['status'];
        $manager_id = $input['manager_id'];

        if ($sDate != null && $eDate != null) {
            $feedings = Feeding::whereDate('feeding_date', '>=', $sDate)
                ->whereDate('feeding_date', '<=', $eDate)
                ->where('manager_id', $manager_id)
                ->orderBy('feeding_date', 'asc')
                ->get();
        }
        //    foreach ($feedings as $feeding) {
        //        Feeding::whereIn('id', [$feeding->id])->update(['status' => $status]);
        //    }

        // get roles wise users
        $users = User::where('user_type', '=', 'Admin')->get();

        foreach ($users as $user) {
            $user->notify(new NewFeedingNotification("New payment request!"));
        }


        // return view('reports.feeding_reports', compact('feedings', 'sDate', 'eDate'))->with('success', 'Request has been updated.');
        return redirect()->back()->with('success', 'Request has been submitted.');
    }


    // show all activities from activityLog
    public function activityLog()
    {
        $logs = Activity::orderBy('id', 'DESC')->get();
        //   $logs = Activity::all();
        return view('activity_log.log_list', compact('logs'));
    }

    // user role wise notification list
    public function notification()
    {
        DB::table('notifications')->where('notifiable_id', '=', \auth()->id())->update(['read_at' => date('Y-m-d H:i:s')]);
        return view('notifications.notification_list');
    }

    public function prepare_report(Request $request)
    {
        $input = $request->all();
        $sDate = $input['sdate'];
        $eDate = $input['edate'];
        $status = $input['status'];
        $manager_id = $input['manager_id'];
        $feedings = [];

        if ($sDate != null && $eDate != null) {
            $feedings = Feeding::whereDate('feeding_date', '>=', $sDate)
                ->whereDate('feeding_date', '<=', $eDate)
                ->where('manager_id', $manager_id)
                ->where('status', $status)
                ->orderBy('feeding_date', 'asc')
                ->pluck('id');
        }

        //        return $feedings;

        if (sizeof($feedings) > 0) {
            $data = array(
                'state_admin_id' => $manager_id,
                'from_date' => $sDate,
                'to_date' => $eDate,
                'state' => Auth::user()->state,
                'feeding_ids' => serialize($feedings),
            );

            PaymentReport::create($data);
            Feeding::whereIn('id', $feedings)->update(['status' => 'Requested']);

            // get roles wise users
            $users = User::where('user_type', '=', 'Admin')->get();

            foreach ($users as $user) {
                $user->notify(new NewFeedingNotification("New payment request!"));
            }

            return redirect()->back()->with('success', 'Payment requested successfully.');
        }
        return redirect()->back()->with('success', 'No new feeding payment found');
    }

    public function report_details($id)
    {
        $report = PaymentReport::findOrFail($id);
        $feedings = Feeding::whereIn('id', unserialize($report->feeding_ids))->get();
        $sDate = $report->from_date;
        $eDate = $report->to_date;
        return view('reports.feeding_reports', compact('feedings', 'sDate', 'eDate', 'id'));
    }

    public function paid_report(Request $request)
    {
        $id = $request->input('id');
        $report = PaymentReport::findOrFail($id);
        $feedings = Feeding::whereIn('id', unserialize($report->feeding_ids))->update(['status' => 'Paid']);
        $report->is_paid = true;
        $report->save();

        $user = User::find($report->state_admin_id);
        $user->notify(new NewFeedingNotification("Your payment has been approved!"));


        return redirect('report-form')->with('success', 'Payment has been mark as paid');
    }
}
