<?php

namespace App\Http\Controllers;

use App\Payment;
use App\Withdraw;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Auth;
use App\Notifications\NewWithdrawNotification;
use DB;
use App\User;

class WithdrawController extends Controller
{
    public function index()
    {

        // if (\auth()->user()->user_type == "Admin"){
        $id = Auth::user()->id;
        $user = User::find($id);
        $roleObject = $user->roles;
        $user_type = $roleObject[0]->name;
        if ($user_type == "Admin") {
            //changing notification status
            $data = Withdraw::orderBy('id', 'DESC')->get();
            Withdraw::where('notification', '=', 0)->update(['notification' => 1]);
        } else {
            $data = Withdraw::where('manager_id', \auth()->id())->orderBy('id', 'DESC')->get();
            Withdraw::where('manager_id', Auth::id())->where('notification', '=', 2)->update(['notification' => 3]);
        }

        return view('payment.withdraw', compact('data'));
    }
    public function detail($id)
    {
        $withdraw = Withdraw::find($id);
        $status = $withdraw->status;
        $manager_id = $withdraw->manager_id;
        $date = Carbon::createFromDate($withdraw->withdraw_month);
        $monthName = date("F", mktime(0, 0, 0, $date->month, 10));
        //$data = Payment::whereYear('created_at', '=', $date->year)->whereMonth('created_at', '=', $date->month)->where('manager_id',$manager_id)->get();
        //$data = Payment::where('year', $date->year)->where('month', $monthName)->where('manager_id', $manager_id)->get();
        $data = DB::select("select payments.*, GROUP_CONCAT(aggregators.company_name) as aggregator_name
                        FROM payments
                        LEFT join `aggregators` on FIND_IN_SET(`aggregators`.`id`,  `payments`.`total_aggregator`)
                        WHERE year = " . $date->year . " AND month = '" . $monthName . "' and manager_id = " . $manager_id . " GROUP BY payments.id");

        return view('payment.detail', compact('data', 'status'));
    }

    public function create(Request $request)
    {
        $monthArr = [
            'January' => '01',
            'February' => '02',
            'March' => '03',
            'April' => '04',
            'May' => '05',
            'June' => '06',
            'July' => '07',
            'August' => '08',
            'September' => '09',
            'October' => '10',
            'November' => '11',
            'December' => '12'
        ];

        $count = Payment::where("id", $request->id)->count();
        //$monthName = date("F", mktime(0, 0, 0,  Carbon::now()->subMonth()->month, 10));
        //$count = Payment::whereYear('created_at', '=', Carbon::now()->subMonth()->year)->where('month', '=',$monthName)->where('withdraw','=',0)->count();
        if ($count > 0) {
            $payment = Payment::where("id", $request->id)->first();
            $monthName = $payment->month;
            $year = $payment->year;
            $data = $request->all();
            $data['withdraw_month'] = $year . "-" . $monthArr[$monthName] . "-01";
            $data['manager_id'] = Auth::id();
            $data['cook_amount'] = Payment::whereYear('created_at', '=', $year)->where('month', '=', $monthName)->where('withdraw', '=', 0)->sum('cook_amount');
            $data['aggregator_amount'] = Payment::whereYear('created_at', '=', $year)->where('month', '=', $monthName)->where('withdraw', '=', 0)->sum('aggregator_amount');
            $data['withdraw_amount'] = Payment::whereYear('created_at', '=', $year)->where('month', '=', $monthName)->where('withdraw', '=', 0)->sum('total_amount');


            // $data = $request->all();
            // $data['withdraw_month'] = Carbon::now()->subMonth();
            // $data['manager_id'] = Auth::id();
            // $data['cook_amount'] = Payment::whereYear('created_at', '=', Carbon::now()->subMonth()->year)->where('month', '=', $monthName)->where('withdraw','=',0)->sum('cook_amount');
            // $data['aggregator_amount'] = Payment::whereYear('created_at', '=', Carbon::now()->subMonth()->year)->where('month', '=', $monthName)->where('withdraw','=',0)->sum('aggregator_amount');
            // $data['withdraw_amount'] = Payment::whereYear('created_at', '=', Carbon::now()->subMonth()->year)->where('month', '=', $monthName)->where('withdraw','=',0)->sum('total_amount');
            $id = Withdraw::create($data);

            $user = User::where('id', $data['manager_id'])->first();
            $user->notify(new NewWithdrawNotification(Withdraw::find($id)->first()));

            Payment::whereYear('created_at', '=', Carbon::now()->subMonth()->year)->where('month', '=', $monthName)->where('withdraw', '=', 0)->update(['withdraw' => 1]);
            return back()->with('success', 'Withdraw request sent successfully');
        } else {
            return back()->with('error', 'No previous month amount to withdraw');
        }
    }
    public function store(Request $request)
    {

    }
    public function show(Withdraw $withdraw)
    {
        $withdraw->update(['status' => 'Approved', 'notification' => 2]);

        $user = User::where('id', $withdraw->manager_id)->first();
        $user->notify(new NewWithdrawNotification($withdraw));

        return back()->with('success', 'Withdraw request approved successfully');
    }

    public function edit(Withdraw $withdraw)
    {
        return view('payment.w_edit', compact('withdraw'));
    }
    public function update(Request $request, Withdraw $withdraw)
    {
        $data = $this->validate($request, [
            'cook_amount' => 'required',
            'aggregator_amount' => 'required',
            'withdraw_amount' => 'required',
        ]);
        $data['status'] = "ReSubmit";
        $withdraw->update($data);
        return back()->with('success', 'Withdraw request updated successfully');
    }
    public function destroy($id)
    {

        $withdraw = Withdraw::find($id);
        $manager_id = $withdraw->manager_id;
        $date = Carbon::createFromDate($withdraw->withdraw_month);
        Payment::whereYear('created_at', '=', $date->year)->whereMonth('created_at', '=', $date->month)->where('manager_id', $manager_id)->update(['withdraw' => 0]);
        $withdraw->delete();
        return back()->with('success', 'Withdraw request deleted successfully');
    }
}