<?php

namespace App\Imports;

use App\Aggregator;
use Carbon\Carbon;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithStartRow;

class AggregatorsImport implements ToCollection, WithStartRow
{
    public function collection(Collection $rows)
 {
     foreach ($rows as $row) 
     {
        Aggregator::updateOrCreate([
         'supply_items'   => $row[7],
         'weekly_comsp'   => $row[8],
         'cons_day'  => $row[9],
         'state'   => $row[12],
           ], [
         'company_name' => $row[1],
         'phone' => $row[2],
         'email' => $row[3],
         'tin' => $row[4],
         'account_no' => $row[5],
         'bank'   => $row[6],
         'unit_cost'   => $row[10],
         'feed_pupils'    => $row[11],
         'week_cost'   => $row[10]*$row[11]*$row[8],
         'amount_twenty'   => $row[10]*$row[11]*$row[8]*4,
         
               ]);
       }
}

/**
     * @return int
     */
    public function startRow(): int
    {
        return 4;
    }
}
