<?php

namespace App\Imports;

use App\Cooks;
use Carbon\Carbon;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithStartRow;

class CooksImport implements ToCollection, WithStartRow
{
    public function collection(Collection $rows)
 {
     foreach ($rows as $row) 
     {
        Cooks::create([
          'id' => $row[0],
          'user_id' => Auth::id(),
         'first_name'   => $row[1],
        //  'feeding_date'   => Carbon::parse($row[1])->format('Y-m-d'),
         'middle_name'   => $row[2],
         'last_name'    => $row[3],
         'gender'  => $row[4],
         'dob'   => Carbon::parse($row[5])->format('Y-m-d'),
         'account_number'   => $row[6],
         'bank_name'   => $row[7],
         'bvn'   => $row[8],
         'phone'   => $row[9],
         'email'   => $row[10],
         'city'   => $row[11],
         'state'   => $row[12],
         'lga'   => $row[13],
         'photo'   => $row[14],
         'school_id'   => $row[15],
         'students'   => $row[16],
         'amount_of_feed_per_pupil'   => $row[17],
         'status'   => $row[18],
            ]);
         }
}

/**
     * @return int
     */
    public function startRow(): int
    {
        return 2;
    }
}
