<?php

namespace App\Imports;

use App\Feeding;
use Carbon\Carbon;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithStartRow;

class FeedingImport implements ToCollection, WithStartRow
{
 public function collection(Collection $rows)
 {
     foreach ($rows as $row) 
     {
        Feeding::create([
          'id' => $row[0],
         'feeding_date'   => Carbon::parse($row[1])->format('Y-m-d'),
         'manager_id'   => $row[2],
         'cooks_id'    => $row[3],
         'aggregators_id'  => $row[4],
         'school_id'   => $row[5],
         'day'   => $row[6],
         'items'   => $row[7],
         'unit_cost'   => $row[8],
         'pupils'   => $row[9],
         'amount_per_day'   => $row[10],
         'amount_of_20_days'   => $row[11],
         'total'   => $row[12],
         'payable_amount'   => $row[13],
         'paid'   => $row[14],
         'status'   => $row[15],
         'state'   => $row[16],
            ]);
         }
}

/**
     * @return int
     */
    public function startRow(): int
    {
        return 2;
    }
}
