<?php

namespace App\Notifications;

use App\Cooks;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class NewCooksNotification extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    private $cooks;
    
    public function __construct(Cooks $cooks)
    {
        $this->cooks = $cooks;
    }  


    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['database'];
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            'message' => $this->cooks->first_name.' '.$this->cooks->middle_name.' '.$this->cooks->last_name.' Cooks '.$this->cooks->status.', added by '.\App\User::get_user_name($this->cooks->user_id)
        ];
    }
}
