<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ProgramManager extends Model
{
    protected $table = 'program_managers';
    protected $fillable = [
        'user_id',
        'first_name',
        'middle_name',
        'gender',
        'dob',
        'account_number',
        'bank_name',
        'bvn',
        'phone',
        'email',
        'state',
        'lga',
        'photo',
        'school_id',
        'students',
        'is_active',
    ];

   public function getPhotoAttribute($value)
   {
       if ($value) {
           return asset('uploads/' . $value);
       } else {
           return asset('backend/dist/img/avatar.png');
       }
   }

    public function school()
    {
        return $this->hasOne(School::class, 'id', 'school_id');
    }

    public function getFullNameAttribute(){
             return $this->first_name . ' ' . $this->middle_name;
    }

}
