<?php

namespace App\Providers;

use App\Aggregator;
use App\Cooks;
use App\Feeding;
use App\School;
use Illuminate\Notifications\Notification;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\ServiceProvider;
use Spatie\Permission\Models\Role;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Schema::defaultStringLength(191);
        view()->composer('*', function ($view) {
            // roles wise user
           $roles = Role::all();
           $view->with('user_roles', $roles);

           // state wise schools
           $schools = School::distinct()->orderBy('id', 'DESC')->select('id', 'state')->get();
           $view->with('all_school', $schools);

           // state wise cook
           $cooks = Cooks::distinct()->orderBy('id', 'DESC')->select('id', 'state')->groupBy('state')->get();
           $view->with('all_cook', $cooks);

           // state wise aggregator
           $aggregators = Aggregator::distinct()->orderBy('id', 'DESC')->select('id', 'state')->groupBy('state')->get();
		   $view->with('all_aggregator', $aggregators);

           // state wise feeding/pupils
           $feedings = Feeding::distinct()->orderBy('id', 'DESC')->select('id', 'state')->get();
           $view->with('all_feeding', $feedings);
        });
       
    }
}
