<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\LogOptions;

class School extends Model
{
    use LogsActivity;

    protected $table = 'schools';
    
    protected $fillable = [
        'name',
        'contact_person',
        'phone',
        'email',
        'students',
        'state',
        'lga',
        'address',
        'is_active',
        'is_sponcered',
        'status'
    ];

    protected static $logAttributes = ['*'];
    protected static $logName = 'School';

    public function getDescriptionForEvent(string $eventName): string
    {
        return "School has been {$eventName}.";
    }

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logAll()
            ->useLogName('School');
    }
}
