<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddSomeFieldsToCooksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('cooks', function (Blueprint $table) {
            $table->string('last_name')->nullable()->after('middle_name');
            $table->string('city')->nullable()->after('email');
            $table->string('amount_of_feed_per_pupil')->nullable()->after('students');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('cooks', function (Blueprint $table) {
            $table->dropColumn('last_name');
            $table->dropColumn('city');
            $table->dropColumn('amount_of_feed_per_pupil');
        });
    }
}
