<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddSomeFieldsToFeedingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('feedings', function (Blueprint $table) {
            $table->string('amount_per_day')->nullable()->after('pupils');
            $table->string('amount_of_20_days')->nullable()->after('amount_per_day');
            $table->string('total')->nullable()->after('amount_of_20_days');
            $table->string('status')->default('Requested')->after('paid');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('feedings', function (Blueprint $table) {
            $table->dropColumn('amount_per_day');
            $table->dropColumn('amount_of_20_days');
            $table->dropColumn('total');
            $table->dropColumn('status');
        });
    }
}
