<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddFieldsToAggregatorsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('aggregators', function (Blueprint $table) {
            $table->string('status')->default('Pending')->after('is_active');
            $table->string('expired_at')->nullable()->after('status');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('aggregators', function (Blueprint $table) {
            $table->dropColumn('status');
            $table->dropColumn('expired_at');
        });
    }
}
