<!DOCTYPE html>
<html lang="en">

<head>
    <title>All States</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
    <!--Start of Tawk.to Script-->
    <script type="text/javascript">
        var Tawk_API = Tawk_API || {},
            Tawk_LoadStart = new Date();
        (function() {
            var s1 = document.createElement("script"),
                s0 = document.getElementsByTagName("script")[0];
            s1.async = true;
            s1.src = 'https://embed.tawk.to/6212976e1ffac05b1d7ad09e/1fsc9v2ns';
            s1.charset = 'UTF-8';
            s1.setAttribute('crossorigin', '*');
            // s0.parentNode.insertBefore(s1, s0);
        })();
    </script>
    <!--End of Tawk.to Script-->
    <style>
        .custom {
            float: right !important;
            font-size: 1.6rem;
        }

        .m {
            margin-top: 7px;
        }

        .mb {
            margin-bottom: 7px;
        }

        .sam {
            background-color: #38B24A;

        }

        a.list-group-item,
        button.list-group-item {
            color: #FFFFFF;}
    </style>
</head>

<body style="margin-top: 10px; margin-bottom: 20px">
    <div class="container">
        <div class="row">
            @if(session()->has('message'))
            <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="alert alert-{{session('type')}}" role="alert">
                    {{session('message')}}
                </div>
            </div>
            @endif
            <div class="col-lg-12 col-md-12 col-sm-12 mb sam">
                <input id="search" class="form-control" type="text" placeholder="Search School in {{$gov}} LGA...">
            </div>
            <div id="res"></div>
        </div>
    </div>
    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Comment Against : <b class="text-danger" id="school_name"></b></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{url('send-report')}}" method="post">
                    @csrf
                    <div class="modal-body">
                        <input id="school" type="hidden" name="school_id" value="">
                        <textarea name="report" class="form-control" required placeholder="Comment Here"></textarea>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Send Comment</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    {{--add school model--}}
    <div class="modal fade" id="exampleModalAdd" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Suggest School In <b class="text-danger">{{$gov}}
                        </b>Government</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{route('add_school')}}" method="post">
                    @csrf
                    <div class="modal-body">
                        <input type="hidden" name="state" value="{{$state}}">
                        <input type="hidden" name="lga" value="{{$gov}}">
                        <input name="editor_name" class="form-control" type="text" required placeholder="Your Name (Required)"><br>
                        <input name="editor_email" class="form-control" type="email" required placeholder="Your Email (Required)"><br>
                        <input name="name" class="form-control" type="text" required placeholder="School Name (Required)"><br>
                        <input name="contact_person" class="form-control" type="text" placeholder="School Contact Person (optional)"><br>
                        <input name="phone" class="form-control" type="text" placeholder="School Phone (optional)"><br>
                        <input name="email" class="form-control" type="email" placeholder="School Email (optional)"><br>
                        <textarea name="address" class="form-control" placeholder="School Address (optional)"></textarea>
                    </div>
                    <input type="text" name="is_sponcered" value="suggested">
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Suggest New School</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{--ajax search--}}
    <script>
        var timer = null;
        $('#search').keydown(function() {
            clearTimeout(timer);
            timer = setTimeout(call, 500)
        });

        function call() {
            var keyword = $("#search").val();

            $.ajax({
                type: 'GET',
                url: '{{url("get-gov-school/")}}/' + keyword,
                data: {
                    gov: '{{$gov}}'
                },
                success: function(data) {
                    $("#res").html('');
                    if (data.length > 0) {
                        $.each(data, function(k, v) {
                            var res = '<div class="col-lg-6 col-md-6 col-sm-6 col-12 m">\n' +
                                '                <p class="list-group-item sam"><span id="school_' + v
                                .id + '">' + v.name + '</span>\n' +
                                '                    <button type="button" onclick="set_info(' + v.id +
                                ')" class="btn btn-sm btn-outline-primary pull-right" data-toggle="modal" data-target="#exampleModal">\n' +
                                '                        Comment\n' +
                                '                    </button>\n' +
                                '                </p>\n' +
                                '            </div>';
                            $("#res").append(res);

                        });
                    } else {
                        var res =
                            '<div class="text-center"><br><span class="text-danger">No School found...! <br></span><br><button type="button" class="btn btn-outline-primary" data-toggle="modal" data-target="#exampleModalAdd">\n' +
                            '                                    Suggest a new school to be added to NHGSFP\n' +
                            '                                </button></div>';
                        $("#res").append(res);
                    }
                }
            });
        }
    </script>
    <script>
        function set_info(id) {
            $("#school").val(id);
            var name = $("#school_" + id).text();
            $("#school_name").text(name);
        }
    </script>
</body>

</html>