@extends('layouts.master')

@section('title', 'Payment detail')

@section('content')
    <div class="row">
        <div class="col-md-12 col-lg-12">
                <div class="card">
                    <div class="card-header py-2">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="mb-0">Edit Withdraw</h6>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <form method="post" id="form" action="{{route('withdraw.update',$withdraw->id)}}">
                            @method("PUT")
                        @csrf
                        <div class="row">
                            <div class="col-md-4 mb-2">
                                <label>Enter Aggregator Amount</label>
                                <input value="{{$withdraw->aggregator_amount}}" type="number" min="1" id="aggregator_amount" required name="aggregator_amount" class="form-control txt" placeholder="Enter aggregator amount">
                                @error('aggregator_amount')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                            <div class="col-md-4 mb-2">
                                <label>Enter Cook Amount</label>
                                <input value="{{$withdraw->cook_amount}}" type="number" min="1" id="cook_amount" required name="cook_amount" class="form-control txt" placeholder="Enter cook amount">
                                @error('cook_amount')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                            <div class="col-md-4 mb-2">
                                <label>Total Withdraw Amount</label>
                                <input value="{{$withdraw->withdraw_amount}}" type="number" min="1" readonly id="withdraw_amount" required name="withdraw_amount" class="form-control" placeholder="Enter withdraw amount">
                                @error('withdraw_amount')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                            <div class="col-md-12 text-right">
                                {{ Form::submit('Update', ['class' => 'btn btn-primary']) }}
                            </div>
                        </div>
                        </form>
                    </div>
                </div>
            </div>
    </div>
@endsection
@section('custom-js')
    <script>
        $(document).ready(function () {

            $("#form").on('input', '.txt', function () {
                var calculated_total_sum = 0;

                $("#form .txt").each(function () {
                    var get_textbox_value = $(this).val();
                    if ($.isNumeric(get_textbox_value)) {
                        calculated_total_sum += parseFloat(get_textbox_value);
                    }
                });
                $("#withdraw_amount").val(calculated_total_sum);
            });
        });
    </script>
@endsection
