@extends('layouts.master')

@section('content')

    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h2><i class="fa fa-list"></i> Blog List
                    @can('post-create')
                    <a href="{{ route('posts.create') }}" class="btn btn-success pull-right">Add New Blog</a></h2>
                    @endcan
                </div>
           <div class="card-body">
                <table class="datatables-users table border-top dataTable no-footer dtr-column" id="post">
                    <thead>
                        <tr>
                            <th>SL</th>
                            <th>Title</th>
                            <th>Photo</th>
                            <th>Post Type</th>
                            <th>Status</th>
                            <th>Created By</th>
                            @if(auth()->user()->can('post-edit') || auth()->user()->can('post-delete'))
                            <th>Action</th>
                            @endif
                        </tr>
                        </thead>
                    <tbody>
                        @foreach ($posts as $post)
                        <tr>
                            <td>{{ $loop->index+1 }}</td>
                            <td> {{ Str::limit($post->title, 20, '...') }} </td>
                            <td><img src="{{ $post->thumbnail }}" height="40" width="60" alt=""></td>

                            <td>{{ $post->post_type }}</td>
                            <td>{{ $post->status }}</td>
                            <td> {{ App\User::get_user_name($post->user_id) }} </td>

                            <td class="form-inline">
                                @can('post-edit')
                                    <a href="{{ route('posts.edit', $post->id) }}" class="" style="margin-right: 3px;" title="Edit"><i class="ti ti-edit ti-sm mx-2"></i></a>
                                @endcan
                                @can('post-delete')
                                {{-- {!! Form::open(['method' => 'DELETE', 'route' => ['posts.destroy', $post->id] ]) !!}
                                {{ Form::button('<i class="fa fa-trash"></i>', ['type' => 'submit', 'class' => 'btn-sm btn-danger', 'id'=>'delete', 'title' => 'Delete'] )  }}
                                {!! Form::close() !!} --}}

                                <a href="{{ route('posts.destroy', $post->id) }}"  type="submit" title="Update" style="margin-right:3px"><i class="ti ti-trash ti-sm mx-2"></i></a>
                                @endcan
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection
@section('custom-js')
    <script>
        $(document).ready(function () {
            $('#post').DataTable();
        });
    </script>
@endsection

