@extends('layouts.master')
@section('content')

    <div class="row">
        <div class="col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header py-2">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="mb-0">Payment Report</h6>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    {{-- date wise feeding report --}}
                  @if(auth()->user()->hasrole('Admin'))
                  {!! Form::open(array('url'=> 'date-wise-feeding-report', 'method' => 'POST', 'class'=>'form-horizontal', 'target' => '_blank')) !!}
                  <div class="row form-group">
                      <div class="col-md-2 mt-4">
                          <b>Date Wise Feeding Report</b>
                      </div>
                      <div class="col-md-3">Start Date <strong class="text-danger">*</strong> {{ Form::date('sdate', \Carbon\Carbon::today()->format('d-m-Y'), ['class'=>'form-control', 'required']) }}</div>
                      <div class="col-md-3">End Date  <strong class="text-danger">*</strong> {{ Form::date('edate', \Carbon\Carbon::today()->format('d-m-Y'), ['class'=>'form-control', 'required']) }}</div>
                      <div class="col-md-2">Status {{ Form::select('status',  ['Unpaid' => 'Unpaid', 'Paid' => 'Paid', 'Cancel' => 'Cancel', 'Others' => 'Others'], null, ['class'=>'form-control', 'placeholder' => 'All']) }}</div>
                      <div class="col-md-2"><br><button type="submit" class="btn btn-success buttons-collection dropdown-toggle btn-label-secondary mx-3" tabindex="0" aria-controls="DataTables_Table_0" type="button" aria-haspopup="dialog" aria-expanded="false"><span><i class="ti ti-screen-share me-1 ti-xs"></i>Search</span><span class="dt-down-arrow"></span></button></div>
                  </div>
                  {!! Form::close() !!}
                  @else
                  {!! Form::open(array('route'=> 'report.prepare', 'method' => 'POST', 'class'=>'form-horizontal')) !!}
                  <div class="row form-group">
                      <div class="col-md-2 mt-4">
                          <b>Date Wise Feeding Report Request</b>
                      </div>
                      <div class="col-md-2">Start Date <strong class="text-danger">*</strong> {{ Form::date('sdate', \Carbon\Carbon::today()->format('d-m-Y'), ['class'=>'form-control', 'required']) }}</div>
                      <div class="col-md-2">End Date  <strong class="text-danger">*</strong>{{ Form::date('edate', \Carbon\Carbon::today()->format('d-m-Y'), ['class'=>'form-control', 'required']) }}</div>
                      <div class="col-md-2">State Admin {{ Form::text('',  Auth::user()->name, ['class'=>'form-control', 'readonly']) }}</div>
                      <div class="col-md-2">Status  <strong class="text-danger">*</strong>{{ Form::select('status',  ['Unpaid' => 'Unpaid'], null, ['class'=>'form-control', 'required']) }}</div>
                      <div class="col-md-2"><br>
                        {{ Form::hidden('manager_id', Auth::user()->id) }}
                      {{ Form::submit('Request for payment', array('class' => 'btn btn-primary')) }}</div>
                  </div>
                  {!! Form::close() !!}
                  @endif


                   @isset($payment_requests)

                  <div class="table-responsive">
                    <table class="datatables-users table border-top dataTable no-footer dtr-column" id="category">
                        <thead>
                            <tr>
                                <th>SL</th>
                                <th>From Date</th>
                                <th>To Date</th>
                                <th>Requested By</th>
                                <th>Requested On</th>
                                <th>Status</th>
                                @if(auth()->user()->can('feeding-edit') || auth()->user()->can('feeding-delete'))
                                <th>Action</th>
                                @endif
                            </tr>
                        </thead>
                        <tbody>

                            @foreach ($payment_requests as $payment)
                                <tr>
                                    <td>{{ $loop->index + 1 }}</td>
                                    <td>{{ $payment->from_date }}</td>
                                    <td>{{ $payment->to_date }}</td>

                                    @if(\App\Helpers\StaticData::checkManagers($payment->state_admin_id))
                                    <td>{{ \App\User::get_user_name($payment->state_admin_id) }}</td>
                                    @else
                                    <td></td>
                                    @endif
                                    <td>{{ \Carbon\Carbon::parse($payment->created_at)->diffForHumans() }}</td>
                                    <td>{{ $payment->is_paid ==true? 'Paid':'Unpaid' }}</td>
                                    @if(auth()->user()->can('feeding-edit') || auth()->user()->can('feeding-delete'))
                                        <td>
                                            <a href="{{ url('report-details', $payment->id) }}" target="_blank">Details</a>
                                        </td>
                                    @endif
                                </tr>
                            @endforeach

                        </tbody>
                    </table>

                </div>

                  @endisset

                </div>
            </div>
        </div>
    </div>
@endsection
@section('custom-js')
    <script>
        $(document).ready(function() {
            $("#category").DataTable({
                "paging":   false,
                "info":     false
            });
        });
    </script>
@endsection
