@extends('layouts.master')

@section('content')
    <div class="row">
        <div class="col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header py-2">
                    <div class="d-flex justify-content-between align-items-center">
                        <h6 class="mb-0">Add New School</h6>
                        @can('school-list')
                            <a href="{{ route('school.index') }}" class="btn btn-success btn-sm">
                                <i class="fas fa-align-justify mr-1"></i> School List
                            </a>
                        @endcan
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('school.store') }}" method="POST" class="form-horizontal">
                        @csrf

                        @include('school.fields', ['school' => null])

                        <div class="row form-group">
                            <div class="col-md-4"></div>
                            <div class="col-md-8 mt-2">
                                <button type="reset" class="btn btn-warning waves-effect waves-light">Reset</button>
                                <button type="submit" class="btn btn-primary waves-effect waves-light">Create</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('custom-js')
    <script>
        $(document).ready(function () {
            $('#state').select2();

            let CSRF_TOKEN = $('meta[name="csrf-token"]').attr('content');
            let state_name = '';

            $("#state").on('change', function () {
                state_name = $(this).val();
            });

            $("#lga").select2({
                ajax: {
                    url: "{{ url('get-lga') }}",
                    type: "GET",
                    dataType: 'json',
                    data: function (params) {
                        return {
                            _token: CSRF_TOKEN,
                            search: params.term,
                            state: state_name,
                        };
                    },
                    processResults: function (response) {
                        return {
                            results: response
                        };
                    },
                    cache: true
                }
            });
        });
    </script>
@endsection