@extends('layouts.master')

@section('content')
    <div class="row">
        <div class="col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header py-2">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="mb-0">Edit School</h6>
                        </div>
                        <div class="text-right">
                            @can('school-list')
                                <a href="{{ route('school.index') }}" class="btn btn-success btn-sm mr-1">
                                    <i class="fas fa-align-justify mr-1"></i>School List
                                </a>
                            @endcan
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <form method="POST" action="{{ route('school.update', $school->id) }}">
                        @csrf
                        @method('PUT')

                        @include('school.fields', ['school' => $school, 'states' => $states, 'lga' => $lga])

                        <div class="row form-group mt-3">
                            <div class="col-md-4"></div>
                            <div class="col-md-8">
                                <button type="reset" class="btn btn-warning waves-effect waves-light">Reset</button>
                                <button type="submit" class="btn btn-primary waves-effect waves-light">Update</button>
                            </div>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>
@endsection

@section('custom-js')
    <script>
        $(document).ready(function () {
            $('#state').select2();
            $('#lga').select2();

            let CSRF_TOKEN = $('meta[name="csrf-token"]').attr('content');
            let state_id = $('#state').val();

            $("#state").on('change', function () {
                state_id = $(this).val();
            });

            $('#lga').select2({
                ajax: {
                    url: "{{ url('get-lga') }}",
                    type: "GET",
                    dataType: 'json',
                    delay: 250,
                    data: function (params) {
                        return {
                            _token: CSRF_TOKEN,
                            search: params.term,
                            state: state_id,
                        };
                    },
                    processResults: function (response) {
                        return {
                            results: response
                        };
                    },
                    cache: true
                }
            });
        });
    </script>
@endsection