<!-- Created by Ariful Islam at 06/27/2020 - 5:08 AM -->
@extends('layouts.master')
@section('title', 'User Management')
@section('content')

    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-lg-8">
                    <div class="pull-left">
                        <h2>User Management
                        <a class="btn btn-success" href="{{ route('users.create') }}"> Create New User</a>
                    </h2>
                    </div>
                </div>
            </div>
        
            <table class="datatables-users table border-top dataTable no-footer dtr-column" id="users">
                <thead>
                <tr>
                    <th>No</th>
                    <th>Photo</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Roles</th>
                    <th>State</th>
                    <th>Expire At</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($data as $key => $user)
                    <tr>
                        <td>{{ $loop->index+1 }}</td>
                        <td><img class="rounded-circle" src="{{ $user->photo }}" height="40px" width="40px" alt=""></td>
                        <td>{{ $user->name }}</td>
                        <td>{{ $user->email }}</td>
                        <td>
                            @if(!empty($user->getRoleNames()))
                                @foreach($user->getRoleNames() as $v)
                                    <label class="badge badge-success">{{ $v }}</label>
                                @endforeach
                            @endif
                        </td>
                        <td>{{ $user->state }}</td>
                        <td>{{ $user->expired_at }}</td>
                        <td>
                            <a class="ti ti-eye ti-sm mx-2" href="{{ route('users.show',$user->id) }}"></a>
                            <a class="ti ti-edit ti-sm mx-2" href="{{ route('users.edit',$user->id) }}"></a>
                            {!! Form::open(['method' => 'DELETE','id'=>'delUser','route' => ['users.destroy', $user->id],'style'=>'display:inline']) !!}
                            <!-- {!! Form::submit('Delete', ['class' => 'btn btn-danger waves-effect waves-light', 'id' => 'delete','style'=>"background:rgb(255 6 6)!important"]) !!} -->
                             <a href = "javascript:$('#delUser').submit();" type="submit" title="Update" style="margin-right:3px" id="delete"><i class="ti ti-trash ti-sm mx-2"></i></a>
                            {!! Form::close() !!} 
                            <!-- <a href="{{ route('users.destroy', $user->id) }}"  type="submit" title="Update" style="margin-right:3px"><i class="ti ti-trash ti-sm mx-2"></i></a> -->
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
        </div>
    </div>

@endsection

@section('custom-js')
     <script>
          $(document).ready(function() {
            $("#users").DataTable();

        })
     </script>
@endsection
