@extends('layouts.app')

@section('content')
<div class="container">
       
    @include('slider')

    <div class="container mt-4">
        <div class="row">
            <div class="col-md-9">

              <div class="top-section mb-5">
               <img src="{{ $blog->thumbnail }}" class="d-block w-100 mb-2" style="height: 450px" alt="">      
               <small class="text-muted p float-right">{{ \Carbon\Carbon::parse($blog->created_at)->format('d M, Y') }} (By {{ App\User::get_user_name($blog->user_id) }})</small>
            </div> 
          
            <div class="bottom-section">
                <h2>{{ $blog->title }}</h2>
                <p>{!! $blog->description !!}</p>
            </div>

            </div><!--end col-->
            <div class="col-md-3">
                 <h4>Recent Blog</h4>
                 <ul class="list-group">
                     @foreach ($recent_posts as $recent_post)
                     <li class="list-group-item"><a href="{{ url('details').'/'.$recent_post->slug }}">{{ Str::limit($recent_post->title, 40, '...') }}</a></li>
                     @endforeach
                     
                 </ul>
            </div><!--end col-->
        </div><!--end row-->
    </div>

</div>
@endsection
