@extends('layouts.master')
@section('content')

    <div class="row">
        <div class="col-sm-12 col-md-12">
            <div class="card ">
                <div class="card-header py-2">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="fs-17 font-weight-600 mb-0">State Cooks List</h6>
                        </div>
                        <div class="text-right">
                            {{-- @can('cook-create')
                                <a href="{{ route('cooks.create') }}" class="btn btn-success btn-sm mr-1"><i
                                        class="fas fa-plus mr-1"></i>Add Cook</a>
                            @endcan --}}
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table display table-bordered table-striped table-hover custom-table" id="category">
                            <thead>
                                <tr>
                                    <th>SL</th>
                                    <th>Photo</th>
                                    <th>Name</th>
                                    <th>Gender</th>
                                    <th>Date Of Birth</th>
                                    <th>Phone</th>
                                    <th>School</th>
                                    <th>Total Pupils</th>
                                    <th>Status</th>
                                    <th>Added By</th>
                                    @if(auth()->user()->can('cook-edit') || auth()->user()->can('cook-delete'))
                                    <th>Action</th>
                                    @endif
                                </tr>
                            </thead>
                            <tbody>
                            @php
                                $i = ($cooks->perPage() * ($cooks->currentPage() - 1)) + 1;
                            @endphp
                                @foreach ($cooks as $cook)
                                    <tr>
                                        <td>{{ $i++ }}</td>
                                        <td><img src="{{ $cook->photo }}" alt="" width="65px" height="80px"></td>
                                        <td>{{ $cook->first_name }} {{ $cook->middle_name }} {{ $cook->last_name }}</td>
                                        <td>{{ $cook->gender }}</td>
                                        <td>{{ $cook->dob }}</td>
                                        <td>{{ $cook->phone }}</td>
                                        @if(\App\Helpers\StaticData::checkSchools($cook->school_id))
                                        <td>{{ $cook->school->name }}</td>
                                        @else   
                                        <td></td>
                                        @endif
                                        <td>{{ $cook->students }}</td>
                                        {{-- <td>{{ $cook->is_active == 1 ? 'Active' : 'Inactive' }}</td> --}}
                                        <td>{{ $cook->status }}</td>
                                        <td>{{ \App\User::get_user_name($cook->user_id) }}</td>
                                        @if(auth()->user()->can('cook-edit') || auth()->user()->can('cook-delete'))
                                        <td class="form-inline">
                                            @can('cook-suspend')
                                            <a href="javascript:void();"
                                                class="btn btn-warning btn-xs" title="Suspend" data-toggle="modal" data-target="#cooks_suspend" style="margin-right:3px"><i
                                                     class="fas fa-times-circle"></i></a>
                                            @endcan
                                            @can('cook-report')
                                            <a href="{{ route('cooks.report', $cook->id) }}"
                                                class="btn btn-info btn-xs" title="Payment Report" target="__blank"
                                                style="margin-right:3px"><i class="fas fa-chart-line"></i></a>
                                        @endcan
                                            @can('cook-edit')
                                                <a href="{{ route('cooks.edit', $cook->id) }}"
                                                    class="btn btn-success btn-xs" title="Update" style="margin-right:3px"><i
                                                        class="fas fa-edit"></i></a>
                                            @endcan
                                            @can('cook-delete')
                                                {!! Form::open(['method' => 'DELETE', 'route' => ['cooks.destroy', $cook->id]]) !!}
                                                {{ Form::button('<i class="fa fa-trash"></i>', ['type' => 'submit', 'class' => 'btn btn-danger btn-xs', 'id' => 'delete', 'title' => 'Delete']) }}
                                                {!! Form::close() !!}
                                            @endcan
                                        </td>
                                        @endif
                                    </tr>


                                    <div class="modal fade" id="cooks_suspend">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h4 class="modal-title">Write suspend reason</h4>
                                                    <button type="button" class="close" data-dismiss="modal"
                                                        aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body">
                                                    {!! Form::open(['url' => 'suspend-request-confirm', 'class' => 'form-horizontal', 'files' => true]) !!}
                                                    {!! Form::hidden('type', 'cooks') !!}
                                                    {!! Form::hidden('cooks_aggregators_id', $cook->id) !!}
                                                    <textarea name="reason" rows="5"
                                                        placeholder="Why do you want to suspend his/her"
                                                        class="form-control" required></textarea>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-danger"
                                                        data-dismiss="modal">Cancel</button>
                                                    <button type="submit" class="btn btn-primary">Confirm</button>
                                                    {!! Form::close() !!}
                                                </div>
                                            </div>
                                            <!-- /.modal-content -->
                                        </div>
                                        <!-- /.modal-dialog -->
                                    </div>
                                    <!-- /.modal -->


                                @endforeach

                            </tbody>
                        </table>
                    </div>
                    <div class="row text-center">
                        <div class="col-md-12 text-center">
                            {{ $cooks->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
@section('custom-js')
    <script>
        $(document).ready(function() {
            $("#category").DataTable({
                "info":false
            });
        });
    </script>
@endsection
