@extends('layouts.master')

@section('title', 'Payment Status')

@section('content')
    <div class="row">
        {{--table--}}
         @if($isadmin == 1)
                        <div class="text-right" style="width: 100%;margin-bottom: 5px;margin-right: 5px;">
                            <a href="#" onclick="$('#excelupload').toggle();" class="btn btn-success btn-sm mr-1"><i class="fas fa-upload mr-1"></i>Upload</a>
                        </div>
         @endif
        <div class="col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header py-2">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="mb-0">Payment Status</h6>
                        </div>
                    </div>
                </div>
                <div class="card-body">
				<div id="excelupload" style="display: none;">
					<div class="row mb-4">
						<div class="col-md-3">
							<a
								href="{{ asset('excel_demo/payment_status_sample.xlsx') }}"
								class="btn btn-primary" download> <i class="fas fa-download"></i>
								Download Sample File
							</a> 
						</div>

					</div>
					{!! Form::open(['url' => 'import-payment', 'method' => 'POST',
					'class' => 'form-horizontal', 'files' => true]) !!}
					<div class="row form-group">

						<label for="" class="col-md-2">State</label>
						<div class="col-md-4 input-group mb-3">
							 	<select class="form-control" name="importState">
                                    <option value="">--Choose--</option>
                                    @foreach ($statelist as $key => $state)
                                    	<option value="{{ $state->id }}">{{ $state->name }}</option>
                                   	@endforeach
                                 </select>						
						</div>
					</div>
					<div class="row form-group">
						<label for="" class="col-md-2">Upload Excel File</label>
						<div class="col-md-4 input-group mb-3">
							{{ Form::file('select_file', ['class' => 'btn btn-default',
							'required']) }} @if($errors->has('select_file')) <span
								class="help-block" style="display: block"> <strong
								class="text-danger">{{ $errors->first('select_file') }}</strong>
							</span> @endif
							<div class="input-group-append">{{ Form::submit('Submit',
								['class' => 'btn btn-primary']) }}</div>
						</div>
					</div>
					{!! Form::close() !!}
				</div>
				<div class="col-md-12"
					style="background: #f2f2f2; display: flow-root; padding: 7px; margin-bottom: 15px; border: 1px solid #c1bfbf;">
					<div id="filters" class="" style="text-align: center;">
						{!! Form::open(['url' => 'paymentstatusfiltered', 'method' => 'POST']) !!}
						@if($isadmin == 1)
						<label>State:
						<select name="filterstate" class="form-control" style="width: 230px;">
								@foreach($statelist as $key => $state)
									@if($state->id  == 25)
									<option value="{{ $state->id }}" selected>{{ $state->name }}</option>
									@else
                                    	<option value="{{ $state->id }}">{{ $state->name }}</option>
                                    @endif
                                @endforeach
						</select></label>
						@endif
						<label>Month:<select name="filterMonth" class="form-control"
							style="width: 230px;">
							<option value="January" <?php $month == 'January'? "selected" : ""; ?>>January</option>
							<option value="February" <?php $month == 'February'? "selected" : ""; ?>>February</option>
							<option value="March" <?php $month == 'March'? "selected" : ""; ?>>March</option>
							<option value="April" <?php $month == 'April'? "selected" : ""; ?>>April</option>
							<option value="May" <?php $month == 'May'? "selected" : ""; ?>>May</option>
							<option value="June" <?php echo $month == 'June'? "selected" : ""; ?>>June</option>
							<option value="July" <?php echo $month == 'July'? "selected" : ""; ?>>July</option>
							<option value="August" <?php $month == 'August'? "selected" : ""; ?>>August</option>
							<option value="September" <?php $month == 'September'? "selected" : ""; ?>>September</option>
							<option value="October" <?php $month == 'October'? "selected" : ""; ?>>October</option>
							<option value="November" <?php $month == 'November'? "selected" : ""; ?>>November</option>
							<option value="December" <?php $month == 'December'? "selected" : ""; ?>>December</option>
							</select></label>
						<label>Year:<select name="filterYear" class="form-control"
							style="width: 230px;">
							<option value="<?php echo date('Y')-1; ?>"><?php echo date('Y')-1; ?></option>
							<option value="<?php echo date('Y'); ?>" selected><?php echo date('Y'); ?></option>
							<option value="<?php echo date('Y')+1; ?>"><?php echo date('Y')+1; ?></option>
							</select></label>
						<input type="Submit" class="btn btn-success btn-sm mr-1" value="Search">
						{!! Form::close() !!}
					</div>
				</div>
				<div class="table-responsive">
                        <table class="table display table-bordered table-striped table-hover custom-table" id="category">
                            <thead>
                            <tr>
                            	<th>ID</th>
                                <th>First Name</th>
                                <th>Last Name</th>
                                <th>Bank Name</th>
                                <th>Type</th>
                                <th>Account No</th>
                                <th>Month</th>
                                <th>Status</th>
                                @if($isadmin == 1)
                                <th>State</th>
                                @endif
                            </tr>
                            </thead>
                            <tbody>
                            @foreach ($data as $key => $record)
                                <tr>
                                	<td>{{ $record->id }}</td>
                                    <td>{{ $record->first_name }}</td>
                                    <td>{{ $record->last_name }}</td>
                                    <td>{{ $record->bank_name }}</td>
                                     <td>{{ $record->type }}</td>
                                    <td>{{ $record->account_no }}</td>
                                    <td>{{ $record->month }}</td>
                                    <td>{{ $record->status }}</td>
                                    @if($isadmin == 1)
                                    <td>{{ $record->name }}</td>
                                    @endif
                                </tr>
                            @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        {{--table end--}}
    </div>
    <script>
    
    </script>
    <script src="https://cdn.jsdelivr.net/npm/jquery-tabledit@1.0.0/jquery.tabledit.min.js"></script>
@endsection
@section('custom-js')
    <script>
	var idAdmin = '<?php echo $isadmin; ?>'
        $(document).ready(function() {
            $("#category").DataTable({
                "info":     false
            });
        });

	if(idAdmin == 1){
        $('#category').Tabledit({
            url: 'edit-paymentstatus',
            rowIdentifier: 'id',
            hideIdentifier: false,
            deleteButton: true,
            saveButton: true,
            autoFocus: false,
			restoreButton: false,
            buttons: {
                edit: {
                    class: 'btn btn-sm btn-primary',
                    html: '<span class="fas fa-edit"></span>',
                    action: 'edit'
                },
				delete: {
					class: 'btn btn-sm',
                    html: '<span class="fas fa-trash" style="color:red"></span>',
                    action: 'delete'
				}
            },
            columns: {
                identifier: [0, 'id'],
                editable: [[6, 'statusedit', '{"Paid": "Paid", "Unpaid": "Unpaid"}']]
            },
			onSuccess: function(data, textStatus, jqXHR) {
            	if(data.action == 'delete'){
					$("tr[id="+data.id+"]").remove();
				}
        	},
        });
	}
    </script>
@endsection
