@extends('layouts.master')
@section('custom-css')
    <style>
        #previewImg{
                height: 250px;
                width: 300px;
                margin-top: 20px;
        }
        .profile-user-img {
                border: 3px solid #adb5bd;
                margin: 0 auto;
                padding: 3px;
                height: 200px;
                width: 200px;
            }
    </style>
@endsection 
@section('content')
    <div class="row">
        <div class="col-md-4 offset-4">
             <!-- Profile Image -->
             <div class="card card-primary card-outline">
                <div class="card-body box-profile">
                  <div class="text-center">
                    <img class="profile-user-img img-fluid"
                         src="{{ $user->photo }}"
                         alt="User profile picture">
                  </div>
  
                  <h3 class="profile-username text-center">{{ $user->name }}</h3>
  
                  <p class="text-muted text-center">
                      @if(!empty($user->getRoleNames()))
                    @foreach($user->getRoleNames() as $v)
                      {{ $v }}
                    @endforeach
                     @endif
                 </p>
                  <hr>
                  <button class="btn btn-primary btn-block mb-2" data-toggle="modal" data-target="#change_profile_picture">Change Profile Picture</button>
  
                  <ul class="list-group list-group-unbordered mb-3">
                    <li class="list-group-item">
                      <b>Name</b> <a class="float-right">{{ $user->name }}</a>
                    </li>
                    <li class="list-group-item">
                      <b>Email</b> <a class="float-right">{{ $user->email }}</a>
                    </li>
                    <li class="list-group-item">
                      <b>State</b> <a class="float-right">{{ $user->state }}</a>
                    </li>
                    <li class="list-group-item">
                      <b>Role</b> <a class="float-right">
                        @if(!empty($user->getRoleNames()))
                        @foreach($user->getRoleNames() as $v)
                          {{ $v }}
                        @endforeach
                         @endif
                      </a>
                    </li>
                  </ul>
  
                  <a href="{{ url('change-password') }}" class="btn btn-primary btn-block"><b>Change Password</b></a>
                </div>
                <!-- /.card-body -->
              </div>
              <!-- /.card -->
        </div>
    </div>

    {{-- profile picture change modal --}}
    <div class="modal fade" id="change_profile_picture">
        <div class="modal-dialog modal-lg">
          <div class="modal-content">
            <div class="modal-header">
              <h4 class="modal-title">Change Password</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
                {!! Form::open(['url' => 'save-profile-picture', 'method' => 'PUT', 'files' => true]) !!}
                    <div class="row form-group">
                        <div class="col-md-3"><strong>Choose Image:</strong></div>
                        <div class="col-md-9">
                            {!! Form::file('photo', array('class' => 'form-control', 'id' => 'uploadImg', 'required')) !!}

                            @if($errors->has('photo'))
                            <span class="help-block">
                                <strong class="text-danger">
                                    {{ $errors->first('photo') }}
                                </strong>
                            </span>
                            @endif

                            <img id="previewImg" src="" alt="Image Preview">
                        </div>
                       
                    </div>
                </div>
            <div class="modal-footer">
              <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
              <button type="submit" class="btn btn-primary">Save changes</button>
            </div>
            {!! Form::close() !!}
          </div>
          <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
      </div>
      <!-- /.modal -->
@endsection
@section('custom-js')
<script>
    $(document).ready(function(){
          $("#previewImg").hide();
            $("#uploadImg").on('change', function(){
                let file = $(this).get(0).files[0];

 
        if(file){
            $("#previewImg").show();
            let reader = new FileReader();

            reader.onload = function(){
                $("#previewImg").attr("src", reader.result);
            }

            reader.readAsDataURL(file);
        }
                    })
            })
</script>
@endsection