<?php $__env->startSection('content'); ?>

    <div class="row">
        <div class="col-sm-12 col-md-12">
            <div class="card ">
                <div class="card-header py-2">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="fs-17 font-weight-600 mb-0">List of Aggregators</h6>
                        </div>
                        <div class="text-right">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('aggregator-create')): ?>
                                <a href="<?php echo e(route('aggregators.create')); ?>" class="btn btn-success btn-sm mr-1"><i
                                        class="fas fa-plus mr-1"></i>Add Aggregator</a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                	    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('upload-cook')): ?>
                       	<div class="row mb-4">
                            <div class="col-md-3">
                                <a href="<?php echo e(asset('excel_demo/aggregator_sample_file.xlsx')); ?>" class="btn btn-primary" download> <i class="fas fa-download"></i> Download Sample File</a>
                                
                            </div>
                           
                        </div>
                        <?php echo Form::open(['url' => 'import-aggregatros', 'method' => 'POST', 'class' => 'form-horizontal', 'files' => true]); ?>

                          <div class="row form-group">
        
                            <?php echo e(Form::label('', 'Upload Excel File')); ?>

                            <div class="col-md-4 input-group mb-3"> 
                                <?php echo e(Form::file('select_file', ['class' => 'btn btn-default', 'required'])); ?>

                                <?php if($errors->has('select_file')): ?>
                                <span class="help-block" style="display:block">
                                 <strong class="text-danger"><?php echo e($errors->first('select_file')); ?></strong>
                               </span>
                               <?php endif; ?>
                                <div class="input-group-append">
                                  <?php echo e(Form::submit('Submit', ['class' => 'btn btn-primary'])); ?>

                                </div>
                              </div>
                        </div>
                     <?php echo Form::close(); ?>

                     <?php endif; ?>
                    <div class="table-responsive">
                        <table class="table display table-bordered table-striped table-hover custom-table" id="category">
                            <thead>
                                <tr>
                                    <th>SL</th>
                                    <th>Company Name</th>
                                    <th>Bank Name</th>
                                    <th>AC No</th>
                                    <th>TIN</th>
                                    <th>Items to Supply</th>
                                    <th>Unit Cost(N)</th>
                                    <th>Day of Consumption</th>
                                    <th>Weekly Consumption</th>
                                    <th title="Number of pupils feed">Pupils</th>
                                    <th title="Cost Per Week">Cost Per Week</th>
                                    <th title="Cost 20 Days">Cost 20 days</th>

                                    <th>Status/Verified</th>
                                    <th>Added By</th>
                                    <?php if(auth()->user()->can('aggregator-edit') ||
                                    auth()->user()->can('feeding-report') ||
                                    auth()->user()->can('aggregator-delete') ||
                                    auth()->user()->can('aggregator-suspend')): ?>
                                        <th>Action</th>
                                    <?php endif; ?>
                                </tr>
                            </thead>
                            <tbody>
                            <?php
                                $i = ($aggregators->perPage() * ($aggregators->currentPage() - 1)) + 1;
                            ?>
                                <?php $__currentLoopData = $aggregators; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $aggregator): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($i++); ?></td>
                                        <td><?php echo e($aggregator->company_name); ?></td>
                                        <td><?php echo e($aggregator->bank); ?></td>
                                        <td><?php echo e($aggregator->account_no); ?></td>
                                        <td><?php echo e($aggregator->tin); ?></td>
                                        <td><?php echo e($aggregator->supply_items); ?></td>
                                        <td><?php echo e($aggregator->unit_cost); ?></td>
                                        <td><?php echo e($aggregator->cons_day); ?></td>
                                        <td><?php echo e($aggregator->weekly_comsp); ?></td>
                                        <td><?php echo e($aggregator->feed_pupils); ?></td>
                                        <td><?php echo e($aggregator->week_cost); ?></td>
                                        <td><?php echo e($aggregator->amount_twenty); ?></td>

                                        
                                        <td><?php echo e($aggregator->status); ?>/<?php echo e($aggregator->is_verified == 1 ? 'Verified' : 'Unverified'); ?>

                                        </td>
                                        <td><?php echo e(\App\Aggregator::get_state_name($aggregator->state)); ?></td>
                                        <?php if(auth()->user()->can('aggregator-edit') ||
                                        auth()->user()->can('feeding-report') ||
                                        auth()->user()->can('aggregator-delete') ||
                                        auth()->user()->can('aggregator-suspend')): ?>
                                            <td class="form-inline">
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('aggregator-report')): ?>
                                                    <a href="<?php echo e(route('aggregators.report', $aggregator->id)); ?>"
                                                        class="btn btn-info btn-xs" title="Payment Report" target="__blank"
                                                        style="margin-right:3px"><i class="fas fa-chart-line"></i></a>
                                                <?php endif; ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('aggregator-suspend')): ?>
                                                    <a href="javascript:void()" class="btn btn-warning btn-xs"
                                                        data-toggle="modal" data-target="#aggregator_suspend" title="Suspend"
                                                        style="margin-right:3px"><i class="fas fa-times-circle"></i></a>
                                                <?php endif; ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('aggregator-edit')): ?>
                                                    <a href="<?php echo e(route('aggregators.edit', $aggregator->id)); ?>"
                                                        class="btn btn-success btn-xs" title="Update"
                                                        style="margin-right:3px"><i class="fas fa-edit"></i></a>
                                                <?php endif; ?>
                                                <?php if(auth()->user()->user_type == "Admin"): ?>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('aggregator-delete')): ?>
                                                        <?php echo Form::open(['method' => 'DELETE', 'route' => ['aggregators.destroy', $aggregator->id]]); ?>

                                                        <?php echo e(Form::button('<i class="fa fa-trash"></i>', ['type' => 'submit', 'class' => 'btn btn-danger btn-xs', 'id' => 'delete', 'title' => 'Delete'])); ?>

                                                        <?php echo Form::close(); ?>

                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </td>
                                        <?php endif; ?>
                                    </tr>

                                    <div class="modal fade" id="aggregator_suspend">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h4 class="modal-title">Write suspend reason</h4>
                                                    <button type="button" class="close" data-dismiss="modal"
                                                        aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body">
                                                    <?php echo Form::open(['url' => 'suspend-request-confirm', 'class' => 'form-horizontal', 'files' => true]); ?>

                                                    <?php echo Form::hidden('type', 'aggregators'); ?>

                                                    <?php echo Form::hidden('cooks_aggregators_id', $aggregator->id); ?>

                                                    <textarea name="reason" rows="5"
                                                        placeholder="Why do you want to suspend his/her"
                                                        class="form-control" required></textarea>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-danger"
                                                        data-dismiss="modal">Cancel</button>
                                                    <button type="submit" class="btn btn-primary">Confirm</button>
                                                    <?php echo Form::close(); ?>

                                                </div>
                                            </div>
                                            <!-- /.modal-content -->
                                        </div>
                                        <!-- /.modal-dialog -->
                                    </div>
                                    <!-- /.modal -->


                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                    </div>
                    <!-- <div class="row text-center">
                        <div class="col-md-12 text-center">
                            <?php echo e($aggregators->links()); ?>

                        </div>
                    </div> -->
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('custom-js'); ?>
    <script>
        $(document).ready(function() {
            $("#category").DataTable({
                "info":     false
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\NHG-backup\resources\views/aggregator/index.blade.php ENDPATH**/ ?>