

<?php $__env->startSection('title', 'Payment Status'); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        
         <?php if($isadmin == 1): ?>
                        <div class="text-right" style="width: 100%;margin-bottom: 5px;margin-right: 5px;">
                            <a href="#" onclick="$('#excelupload').toggle();" class="btn btn-success btn-sm mr-1"><i class="fas fa-upload mr-1"></i>Upload</a>
                        </div>
         <?php endif; ?>
        <div class="col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header py-2">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="mb-0">Payment Status</h6>
                        </div>
                    </div>
                </div>
                <div class="card-body">
				<div id="excelupload" style="display: none;">
					<div class="row mb-4">
						<div class="col-md-3">
							<a
								href="<?php echo e(asset('excel_demo/payment_status_sample.xlsx')); ?>"
								class="btn btn-primary" download> <i class="fas fa-download"></i>
								Download Sample File
							</a> 
						</div>

					</div>
					<?php echo Form::open(['url' => 'import-payment', 'method' => 'POST',
					'class' => 'form-horizontal', 'files' => true]); ?>

					<div class="row form-group">

						<label for="" class="col-md-2">State</label>
						<div class="col-md-4 input-group mb-3">
							 	<select class="form-control" name="importState">
                                    <option value="">--Choose--</option>
                                    <?php $__currentLoopData = $statelist; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    	<option value="<?php echo e($state->id); ?>"><?php echo e($state->name); ?></option>
                                   	<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                 </select>						
						</div>
					</div>
					<div class="row form-group">
						<label for="" class="col-md-2">Upload Excel File</label>
						<div class="col-md-4 input-group mb-3">
							<?php echo e(Form::file('select_file', ['class' => 'btn btn-default',
							'required'])); ?> <?php if($errors->has('select_file')): ?> <span
								class="help-block" style="display: block"> <strong
								class="text-danger"><?php echo e($errors->first('select_file')); ?></strong>
							</span> <?php endif; ?>
							<div class="input-group-append"><?php echo e(Form::submit('Submit',
								['class' => 'btn btn-primary'])); ?></div>
						</div>
					</div>
					<?php echo Form::close(); ?>

				</div>
				<div class="col-md-12"
					style="background: #fff; display: flow-root; padding: 7px; margin-bottom: 15px; border: 1px solid #fff;">
					<div id="filters" class="" style="text-align: center;">
						<?php echo Form::open(['url' => 'paymentstatusfiltered', 'method' => 'POST']); ?>

						<?php if($isadmin == 1): ?>
						<label>
						<select name="filterstate" class="form-select text-capitalize" style="width: 230px;">
                            <option value="" selected>Select State</option>
								<?php $__currentLoopData = $statelist; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<?php if($state->id  == 25): ?>
                                    
									<option value="<?php echo e($state->id); ?>" selected><?php echo e($state->name); ?></option>
									<?php else: ?>
                                    	<option value="<?php echo e($state->id); ?>"><?php echo e($state->name); ?></option>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</select></label>
						<?php endif; ?>
						<label><select name="filterMonth" class="form-select text-capitalize"
							style="width: 230px;">
                            <option value="" >Select Month</option>
							<option value="January" <?php $month == 'January'? "selected" : ""; ?>>January</option>
							<option value="February" <?php $month == 'February'? "selected" : ""; ?>>February</option>
							<option value="March" <?php $month == 'March'? "selected" : ""; ?>>March</option>
							<option value="April" <?php $month == 'April'? "selected" : ""; ?>>April</option>
							<option value="May" <?php $month == 'May'? "selected" : ""; ?>>May</option>
							<option value="June" <?php echo $month == 'June'? "selected" : ""; ?>>June</option>
							<option value="July" <?php echo $month == 'July'? "selected" : ""; ?>>July</option>
							<option value="August" <?php $month == 'August'? "selected" : ""; ?>>August</option>
							<option value="September" <?php $month == 'September'? "selected" : ""; ?>>September</option>
							<option value="October" <?php $month == 'October'? "selected" : ""; ?>>October</option>
							<option value="November" <?php $month == 'November'? "selected" : ""; ?>>November</option>
							<option value="December" <?php $month == 'December'? "selected" : ""; ?>>December</option>
							</select></label>
						<label><select name="filterYear" class="form-select text-capitalize"
							style="width: 230px;">

							<option value="">Select Year</option>
							<option value="<?php echo date('Y')-2; ?>"><?php echo date('Y')-2; ?></option>
							<option value="<?php echo date('Y')-1; ?>"><?php echo date('Y')-1; ?></option>
							<option value="<?php echo date('Y'); ?>" selected><?php echo date('Y'); ?></option>
							<option value="<?php echo date('Y')+1; ?>"><?php echo date('Y')+1; ?></option>
							</select></label>
						
                        <button type="Submit" class="btn rounded-pill btn-success waves-effect waves-light">Search</button>
						<?php echo Form::close(); ?>

					</div>
				</div>
				<div class="table-responsive">
                        <table class="datatables-users table border-top dataTable no-footer dtr-column" id="category">
                            <thead>
                            <tr>
                            	<th>ID</th>
                                <th>First Name</th>
                                <th>Last Name</th>
                                <th>Bank Name</th>
                                <th>Type</th>
                                <th>Account No</th>
                                <th>Month</th>
                                <th>Status</th>
                                <?php if($isadmin == 1): ?>
                                <th>State</th>
                                <?php endif; ?>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                	<td><?php echo e($record->id); ?></td>
                                    <td><?php echo e($record->first_name); ?></td>
                                    <td><?php echo e($record->last_name); ?></td>
                                    <td><?php echo e($record->bank_name); ?></td>
                                     <td><?php echo e($record->type); ?></td>
                                    <td><?php echo e($record->account_no); ?></td>
                                    <td><?php echo e($record->month); ?></td>
                                    <td><?php echo e($record->status); ?></td>
                                    <?php if($isadmin == 1): ?>
                                    <td><?php echo e($record->name); ?></td>
                                    <?php endif; ?>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        
    </div>
    <script>
    
    </script>
    <script src="https://cdn.jsdelivr.net/npm/jquery-tabledit@1.0.0/jquery.tabledit.min.js"></script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('custom-js'); ?>
    <script>
	var idAdmin = '<?php echo $isadmin; ?>'
        $(document).ready(function() {
            $("#category").DataTable({
                "info":     false
            });
        });

	if(idAdmin == 1){
        $('#category').Tabledit({
            url: 'edit-paymentstatus',
            rowIdentifier: 'id',
            hideIdentifier: false,
            deleteButton: true,
            saveButton: true,
            autoFocus: false,
			restoreButton: false,
            buttons: {
                edit: {
                    class: 'btn btn-sm btn-primary',
                    html: '<span class="fas fa-edit"></span>',
                    action: 'edit'
                },
				delete: {
					class: 'btn btn-sm',
                    html: '<span class="fas fa-trash" style="color:red"></span>',
                    action: 'delete'
				}
            },
            columns: {
                identifier: [0, 'id'],
                editable: [[6, 'statusedit', '{"Paid": "Paid", "Unpaid": "Unpaid"}']]
            },
			onSuccess: function(data, textStatus, jqXHR) {
            	if(data.action == 'delete'){
					$("tr[id="+data.id+"]").remove();
				}
        	},
        });
	}
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\NHG-backup\resources\views/payment/paymentstatus.blade.php ENDPATH**/ ?>