<?php
    $school = $school ?? null;
?>

<div class="row form-group">
    <div class="col-md-2">
        <label for="name">Name of School <strong class="text-danger">*</strong></label>
    </div>
    <div class="col-md-6">
        <input type="text" name="name" id="name" value="<?php echo e(old('name', optional($school)->name)); ?>" class="form-control" required>
    </div>
</div>

<div class="row form-group">
    <div class="col-md-2">
        <label for="contact_person">School Head <strong class="text-danger">*</strong></label>
    </div>
    <div class="col-md-6">
        <input type="text" name="contact_person" id="contact_person" value="<?php echo e(old('contact_person', optional($school)->contact_person)); ?>" class="form-control" required>
    </div>
</div>

<div class="row form-group">
    <div class="col-md-2">
        <label for="address">Address of School <strong class="text-danger">*</strong></label>
    </div>
    <div class="col-md-6">
        <input type="text" name="address" id="address" value="<?php echo e(old('address', optional($school)->address)); ?>" class="form-control" required>
    </div>
</div>

<div class="row form-group">
    <div class="col-md-2">
        <label for="state">State <strong class="text-danger">*</strong></label>
    </div>
    <div class="col-md-6">
        <select name="state" id="state" class="form-control" required>
            <option value="">--please select--</option>
            <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($state->id); ?>" <?php echo e(old('state', optional($school)->state) == $state->id ? 'selected' : ''); ?>>
                    <?php echo e($state->name); ?>

                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>
</div>

<div class="row form-group">
    <div class="col-md-2">
        <label for="lga">LGA <strong class="text-danger">*</strong></label>
    </div>
    <div class="col-md-6">
        <select name="lga" id="lga" class="form-control" required>
            <option value=""><?php echo e(Request::route()->named('school.edit') ? '--state select first--' : '--select state first--'); ?></option>
            <?php if(Request::route()->named('school.edit') && isset($lga)): ?>
                <?php $__currentLoopData = $lga; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name => $display): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($name); ?>" <?php echo e(old('lga', optional($school)->lga) == $name ? 'selected' : ''); ?>>
                        <?php echo e($display); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        </select>
    </div>
</div>

<div class="row form-group">
    <div class="col-md-2">
        <label for="phone">School Head Phone Number <strong class="text-danger">*</strong></label>
    </div>
    <div class="col-md-6">
        <input type="text" name="phone" id="phone" value="<?php echo e(old('phone', optional($school)->phone)); ?>" class="form-control" required>
    </div>
</div>

<div class="row form-group">
    <div class="col-md-2">
        <label for="students">Number of Students <strong class="text-danger">*</strong></label>
    </div>
    <div class="col-md-6">
        <input type="number" name="students" id="students" value="<?php echo e(old('students', optional($school)->students)); ?>" class="form-control" required>
    </div>
</div>

<?php if(auth()->user()->hasRole('Admin')): ?>
    <div class="row form-group">
        <div class="col-md-2">
            <label for="status">Status</label>
        </div>
        <div class="col-md-6">
            <select name="status" id="status" class="form-control">
                <?php $__currentLoopData = \App\Helpers\StaticData::account_status(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $statusKey => $statusValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($statusKey); ?>" <?php echo e(old('status', optional($school)->status) == $statusKey ? 'selected' : ''); ?>>
                        <?php echo e($statusValue); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
    </div>
<?php else: ?>
    <div class="row form-group">
        <div class="col-md-2">
            <label for="status">Status</label>
        </div>
        <div class="col-md-6">
            <select name="status" id="status" class="form-control">
                <option value="Pending" <?php echo e(old('status', optional($school)->status) == 'Pending' ? 'selected' : ''); ?>>Pending</option>
            </select>
        </div>
    </div>
<?php endif; ?>

<?php $__env->startPush('scripts'); ?>
<script>
    $(document).ready(function () {
        $('#state').select2();
        let CSRF_TOKEN = $('meta[name="csrf-token"]').attr('content');
        let state_name = '';

        $("#state").on('change', function () {
            state_name = $(this).val();
        });

        $("#lga").select2({
            ajax: {
                url: "<?php echo e(url('get-lga')); ?>",
                type: "GET",
                dataType: 'json',
                data: function (params) {
                    return {
                        _token: CSRF_TOKEN,
                        search: params.term,
                        state: state_name,
                    };
                },
                processResults: function (response) {
                    return {
                        results: response
                    };
                },
                cache: true
            }
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH C:\laragon\www\NHG-backup\resources\views/school/fields.blade.php ENDPATH**/ ?>