<div class="mb-3">
    <label for="company_name">Company Name *</label>
    <input type="text" name="company_name" id="company_name" class="form-control" required
        value="<?php echo e(old('company_name', $aggregator->company_name ?? '')); ?>">
</div>

<div class="mb-3">
    <label for="phone">Phone Number *</label>
    <input type="text" name="phone" id="phone" class="form-control" required
        value="<?php echo e(old('phone', $aggregator->phone ?? '')); ?>">
</div>

<div class="mb-3">
    <label for="email">Email *</label>
    <input type="email" name="email" id="email" class="form-control" required
        value="<?php echo e(old('email', $aggregator->email ?? '')); ?>">
</div>

<div class="mb-3">
    <label for="tin">TIN *</label>
    <input type="text" name="tin" id="tin" class="form-control" required
        value="<?php echo e(old('tin', $aggregator->tin ?? '')); ?>">
</div>

<div class="mb-3">
    <label for="account_no">Account No *</label>
    <input type="text" name="account_no" id="account_no" class="form-control" required
        value="<?php echo e(old('account_no', $aggregator->account_no ?? '')); ?>">
</div>

<div class="mb-3">
    <label for="bank">Bank Name *</label>
    <input type="text" name="bank" id="bank" class="form-control" required
        value="<?php echo e(old('bank', $aggregator->bank ?? '')); ?>">
</div>

<div class="mb-3">
    <label for="supply_items">Item Supplied *</label>
    <input type="text" name="supply_items" id="supply_items" class="form-control" required
        value="<?php echo e(old('supply_items', $aggregator->supply_items ?? '')); ?>">
</div>

<div class="mb-3">
    <label for="weekly_comsp">Weekly Consumption *</label>
    <input type="text" name="weekly_comsp" id="weekly_comsp" class="form-control" required
        value="<?php echo e(old('weekly_comsp', $aggregator->weekly_comsp ?? '')); ?>">
</div>

<div class="mb-3">
    <label for="cons_day">Day for Consumption *</label>
    <select name="cons_day[]" id="cons_day" class="form-control select2" multiple required>
        <?php
            $days = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'];
            $selectedDays = old('cons_day', $aggregator->cons_day ?? []);
        ?>
        <?php $__currentLoopData = $days; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($day); ?>" <?php echo e(in_array($day, $selectedDays) ? 'selected' : ''); ?>><?php echo e($day); ?></option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
</div>

<div class="mb-3">
    <label for="unit_cost">Unit Cost (N) *</label>
    <input type="text" name="unit_cost" id="unit_cost" class="form-control" required
        value="<?php echo e(old('unit_cost', $aggregator->unit_cost ?? '')); ?>">
</div>

<div class="mb-3">
    <label for="feed_pupils">Number of Children *</label>
    <input type="number" name="feed_pupils" id="feed_pupils" class="form-control" required
        value="<?php echo e(old('feed_pupils', $aggregator->feed_pupils ?? '')); ?>">
</div>

<div class="mb-3">
    <label for="week_cost">Cost Per Week *</label>
    <input type="number" name="week_cost" id="week_cost" class="form-control" required readonly
        value="<?php echo e(old('week_cost', $aggregator->week_cost ?? '')); ?>">
</div>

<div class="mb-3">
    <label for="amount_twenty">Amount for 20 Days *</label>
    <input type="number" name="amount_twenty" id="amount_twenty" class="form-control" required readonly
        value="<?php echo e(old('amount_twenty', $aggregator->amount_twenty ?? '')); ?>">
</div>

<?php if(auth()->user()->hasRole('Admin')): ?>
    <div class="mb-3">
        <p><strong>Selected State ID:</strong> <?php echo e(old('state', $aggregator->state ?? 'none')); ?></p>
        <label for="state">State *</label>
        <select name="state" id="state" class="form-control" required>
            <option value="">--please select--</option>
            <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($id); ?>" <?php echo e(old('state', $aggregator->state ?? '') == $id ? 'selected' : ''); ?>>
                    <?php echo e($name); ?>

                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>

    </div>



    <div class="mb-3">
        <label for="is_verified">Verified *</label>
        <select name="is_verified" id="is_verified" class="form-control" required>
            <option value="0" <?php echo e(old('is_verified', $aggregator->is_verified ?? '') == 0 ? 'selected' : ''); ?>>Unverified
            </option>
            <option value="1" <?php echo e(old('is_verified', $aggregator->is_verified ?? '') == 1 ? 'selected' : ''); ?>>Verified
            </option>
        </select>
    </div>

    <div class="mb-3">
        <label for="status">Status *</label>
        <select name="status" id="status" class="form-control" required>
            <?php $__currentLoopData = \App\Helpers\StaticData::account_status(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $statusValue => $statusLabel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($statusValue); ?>" <?php echo e(old('status', $aggregator->status ?? '') == $statusValue ? 'selected' : ''); ?>><?php echo e($statusLabel); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>
<?php else: ?>
    <?php if(Request::route()->named('aggregators.create')): ?>
        <div class="mb-3">
            <label for="status">Status *</label>
            <select name="status" id="status" class="form-control" required>
                <option value="Pending" selected>Pending</option>
            </select>
        </div>
    <?php endif; ?>
<?php endif; ?>


<?php $__env->startSection('custom-js'); ?>
    <script>
        // Helper to calculate and update costs
        function calculateCosts() {
            const unitCost = parseFloat(document.querySelector('input[name="unit_cost"]').value) || 0;
            const pupils = parseInt(document.querySelector('input[name="feed_pupils"]').value) || 0;
            const days = document.querySelectorAll('select[name="cons_day[]"] option:checked').length;

            const weekCost = unitCost * pupils * days;
            const twentyDayCost = unitCost * pupils * 20;

            document.getElementById('week_cost').value = weekCost.toFixed(2);
            document.getElementById('amount_twenty').value = twentyDayCost.toFixed(2);
        }

        // Listen to changes
        document.addEventListener('DOMContentLoaded', function () {
            const unitCostInput = document.querySelector('input[name="unit_cost"]');
            const pupilsInput = document.querySelector('input[name="feed_pupils"]');
            const consDaySelect = document.querySelector('select[name="cons_day[]"]');

            if (unitCostInput && pupilsInput && consDaySelect) {
                unitCostInput.addEventListener('input', calculateCosts);
                pupilsInput.addEventListener('input', calculateCosts);
                consDaySelect.addEventListener('change', calculateCosts);
            }

            // Initial calculation on page load if values exist
            calculateCosts();
        });

        // For dropdowns
        $("#state").select2();
        $("#program_manager_id").select2();
    </script>
<?php $__env->stopSection(); ?><?php /**PATH C:\laragon\www\NHG-backup\resources\views/aggregator/fields.blade.php ENDPATH**/ ?>