<?php

use App\State;
use Illuminate\Support\Facades\Auth;

$State = State::all();
$StateUnique = $State->unique('id');
$user_id = Auth::user()->id;


    ?>
<!-- Main Sidebar Container -->

<!-- Menu -->
<aside id="layout-menu" class="layout-menu-horizontal menu-horizontal menu bg-menu-theme flex-grow-0"
    style="height: 80px;">
    <div class="container-xxl d-flex h-100">
        <ul class="menu-inner">
            <!-- Dashboards -->
            <li class="menu-item active">
                <a href="javascript:void(0)" class="menu-link menu-toggle">
                    <i class="menu-icon tf-icons ti ti-smart-home"></i>
                    <div data-i18n="Dashboards">Dashboard</div>
                </a>
                <ul class="menu-sub">
                    <li class="menu-item">
                        <a href="<?php echo e(url('/home')); ?>" class="menu-link">
                            <i class="menu-icon tf-icons ti ti-chart-pie-2"></i>
                            <div data-i18n="Dashboard">Dashboard</div>
                        </a>
                    </li>
                    <li class="menu-item active">
                        <a href="<?php echo e(url('/my-profile')); ?>" class="menu-link">
                            <i class="menu-icon tf-icons ti ti-3d-cube-sphere"></i>
                            <div data-i18n="My Profile">My Profile</div>
                        </a>
                    </li>

                </ul>
            </li>

            <!-- Layouts -->
            <li class="menu-item">
                <a href="javascript:void(0)" class="menu-link menu-toggle">
                    <i class="menu-icon tf-icons ti ti-layout-sidebar"></i>
                    <div data-i18n="Public Tools">Public Tools</div>
                </a>

                <ul class="menu-sub">
                    <li class="menu-item">
                        <a href="<?php echo e(url('/all-reports')); ?>" class="menu-link">
                            <i class="menu-icon tf-icons ti ti-menu-2"></i>
                            <div data-i18n="Reports">Reports</div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php echo e(url('/suggestions')); ?>" class="menu-link">
                            <i class="menu-icon tf-icons ti ti-layout-distribute-vertical"></i>
                            <div data-i18n="Suggestions">Suggestions</div>
                            <?php
if (auth()->user()->hasrole('Admin')) {
    $sch_count = \App\School::all()->where('seen', '=', 0)->count();
} else {
    $state = State::get_state_id(Auth::user()->state);
    $sch_count = \App\School::all()->where('state', '=', $state)->where('seen', '=', 0)->count();
}
                                ?>
                            <?php if($sch_count > 0): ?> <span class="badge badge-danger navbar-badge"><?php echo e($sch_count); ?></span>
                            <?php endif; ?>
                        </a>
                    </li>

                    <!-- Sponsor a school -->
                    <li class="menu-item">
                        <a href="<?php echo e(url('/sponsored_schools')); ?>" class="menu-link">
                            <i class="menu-icon tf-icons ti ti-layout-navbar"></i>
                            <div data-i18n="Sponsor a school">sponsored schools</div>
                        </a>
                    </li>

                </ul>
            </li>

            <!-- Apps -->
            <li class="menu-item">
                <a href="javascript:void(0)" class="menu-link menu-toggle">
                    <i class="menu-icon tf-icons ti ti-layout-grid-add"></i>
                    <div data-i18n="Payments">Payments</div>
                </a>
                <ul class="menu-sub">
                    <li class="menu-item">
                        <a href="<?php echo e(url('/withdraw')); ?>" class="menu-link">
                            <i class="menu-icon tf-icons ti ti-mail"></i>
                            <div data-i18n="Download Payment Request">Download Payment Request</div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php echo e(url('/payment')); ?>" class="menu-link">
                            <i class="menu-icon tf-icons ti ti-messages"></i>
                            <div data-i18n="Payment Request">Payment Request</div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="<?php echo e(url('/paymentstatus')); ?>" class="menu-link">
                            <i class="menu-icon tf-icons ti ti-calendar"></i>
                            <div data-i18n="Payment Status">Payment Status</div>
                        </a>
                    </li>

            </li>


        </ul>
        </li>

        <?php if (\Illuminate\Support\Facades\Blade::check('hasrole', 'Admin')): ?>
        <li class="menu-item">
            <a href="javascript:void(0);" class="menu-link menu-toggle">
                <i class="menu-icon tf-icons ti ti-users"></i>
                <div data-i18n="Role Users">Role Users</div>
            </a>
            <ul class="menu-sub">
                <?php $__currentLoopData = $user_roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="menu-item">
                        <a href="<?php echo e(url('user-role') . '/' . $role->name); ?>" class="menu-link">
                            <div data-i18n="<?php echo e($role->name); ?>"><?php echo e($role->name); ?></div>
                        </a>
                    </li>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </ul>

        </li>
        <?php endif; ?>

        <li class="menu-item">
            <a href="<?php echo e(url('/notifications')); ?>" class="menu-link">

                <div data-i18n="Notifications">Notifications</div>
            </a>
        </li>
        <!-- Components -->
        <li class="menu-item">
            <a href="javascript:void(0)" class="menu-link menu-toggle">
                <i class="menu-icon tf-icons ti ti-toggle-left"></i>
                <div data-i18n="Feature">Feature</div>
            </a>

            <ul class="menu-sub">
                <!-- Cards -->
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('school-manage')): ?>
                    <li class="menu-item">
                        <a href="#" class="menu-link menu-toggle">
                            <i class="menu-icon tf-icons ti ti-id"></i>
                            <div data-i18n="School">School</div>
                        </a>
                        <ul class="menu-sub">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('school-create')): ?>
                                <li class="menu-item">
                                    <a href="<?php echo e(route('school.create')); ?>" class="menu-link">
                                        <div data-i18n="Add New School">Add new School</div>
                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('school-list')): ?>
                                <li class="menu-item">
                                    <a href="<?php echo e(route('school.index')); ?>" class="menu-link">
                                        <div data-i18n="School List">School List</div>
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </li>
                <?php endif; ?>
                <!-- User interface -->
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('state-wise-school')): ?>
                    <li class="menu-item">
                        <a href="javascript:void(0)" class="menu-link menu-toggle">
                            <i class="menu-icon tf-icons ti ti-color-swatch"></i>
                            <div data-i18n="State Data By State">State Data By State</div>
                        </a>
                        <ul class="menu-sub">
                            <?php $__currentLoopData = $StateUnique; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $school): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="menu-item">
                                    <a href="<?php echo e(url('state-wise-school' . '/' . $school->id)); ?>" class="menu-link">
                                        <div data-i18n="<?php echo e(\App\State::get_state($school->id)); ?>">
                                            <?php echo e(\App\State::get_state($school->id)); ?>

                                        </div>
                                    </a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </li>
                <?php endif; ?>
                <!-- Extended components -->
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('cook-manage')): ?>
                    <li class="menu-item">
                        <a href="javascript:void(0)" class="menu-link menu-toggle">
                            <i class="menu-icon tf-icons ti ti-components"></i>
                            <div data-i18n="Cooks">Cooks</div>
                        </a>
                        <ul class="menu-sub">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('cook-create')): ?>
                                <li class="menu-item">
                                    <a href="<?php echo e(route('cooks.create')); ?>" class="menu-link">
                                        <div data-i18n="Add New Cook">Add New Cook</div>
                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('cook-list')): ?>
                                <li class="menu-item">
                                    <a href="<?php echo e(route('cooks.index')); ?>" class="menu-link">
                                        <div data-i18n="Cook List">Cook List</div>
                                    </a>
                                </li>
                            <?php endif; ?>

                        </ul>
                    </li>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('state-wise-cook')): ?>
                    <li class="menu-item">
                        <a href="javascript:void(0)" class="menu-link menu-toggle">
                            <i class="menu-icon tf-icons ti ti-components"></i>
                            <div data-i18n="State Cooks">State Cooks</div>
                        </a>
                        <ul class="menu-sub">
                            <?php $__currentLoopData = $StateUnique; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cook): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="menu-item">
                                    <a href="<?php echo e(url('state-wise-cook' . '/' . $cook->id)); ?>" class="menu-link">
                                        <div data-i18n="<?php echo e(\App\State::get_state($cook->id)); ?>">
                                            <?php echo e(\App\State::get_state($cook->id)); ?>

                                        </div>
                                    </a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </li>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('aggregator-manage')): ?>
                    <li class="menu-item">
                        <a href="javascript:void(0)" class="menu-link menu-toggle">
                            <i class="menu-icon tf-icons ti ti-users"></i>
                            <div data-i18n="Aggregators">Aggregators</div>
                        </a>
                        <ul class="menu-sub">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('cook-create')): ?>
                                <li class="menu-item">
                                    <a href="<?php echo e(route('aggregators.create')); ?>" class="menu-link">
                                        <div data-i18n="Add New Aggregator">Add New Aggregator</div>
                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('cook-list')): ?>
                                <li class="menu-item">
                                    <a href="<?php echo e(route('aggregators.index')); ?>" class="menu-link">
                                        <div data-i18n="Aggregator List">Aggregator List</div>
                                    </a>
                                </li>
                            <?php endif; ?>

                        </ul>
                    </li>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('state-wise-aggregator')): ?>
                    <li class="menu-item">
                        <a href="javascript:void(0)" class="menu-link menu-toggle">
                            <i class="menu-icon tf-icons ti ti-users"></i>
                            <div data-i18n="State Aggregator">State Aggregator</div>
                        </a>
                        <ul class="menu-sub">
                            <?php $__currentLoopData = $StateUnique; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $aggregators): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="menu-item">
                                    <a href="<?php echo e(url('state-wise-aggregator' . '/' . $aggregators->id)); ?>" class="menu-link">
                                        <div data-i18n="<?php echo e(\App\State::get_state($aggregators->id)); ?>">
                                            <?php echo e(\App\State::get_state($aggregators->id)); ?>

                                        </div>
                                    </a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </li>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('feeding-manage')): ?>
                    <li class="menu-item">
                        <a href="javascript:void(0)" class="menu-link menu-toggle">
                            <i class="menu-icon tf-icons ti ti-layout-navbar"></i>
                            <div data-i18n="Pupils">Pupils</div>
                        </a>
                        <ul class="menu-sub">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('feeding-create')): ?>
                                <li class="menu-item">
                                    <a href="<?php echo e(route('feedings.create')); ?>" class="menu-link">
                                        <div data-i18n="Add New Pupils">Add New Pupils</div>
                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('feeding-list')): ?>
                                <li class="menu-item">
                                    <a href="<?php echo e(route('feedings.index')); ?>" class="menu-link">
                                        <div data-i18n="Pupils List">Pupils List</div>
                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('feeding-list')): ?>
                                <li class="menu-item">
                                    <a href="<?php echo e(route('feedings.request_list')); ?>" class="menu-link">
                                        <div data-i18n="Payment Request List">Payment Request List</div>
                                    </a>
                                </li>
                            <?php endif; ?>

                        </ul>
                    </li>
                <?php endif; ?>
                <!-- Icons -->
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('report')): ?>
                            <li class="menu-item">
                                <a href="javascript:void(0)" class="menu-link menu-toggle">
                                    <i class="menu-icon tf-icons ti ti-users"></i>
                                    <div data-i18n="Reports">Reports</div>
                                </a>
                                <ul class="menu-sub">
                                    <li class="menu-item">
                                        <a href="<?php echo e(url('report-form')); ?>" class="menu-link">
                                            <div data-i18n="Make Report">Make Report</div>
                                        </a>
                                    </li>

                                </ul>
                            </li>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('post-manage')): ?>
                                <li class="menu-item">
                                    <a href="javascript:void(0)" class="menu-link menu-toggle">
                                        <i class="menu-icon tf-icons ti ti-layout-navbar"></i>
                                        <div data-i18n="Blog/Post">Blog/Post</div>
                                    </a>
                                    <ul class="menu-sub">
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('post-create')): ?>
                                            <li class="menu-item">
                                                <a href="<?php echo e(route('posts.create')); ?>" class="menu-link">
                                                    <div data-i18n="Add New Blog">Add New Blog</div>
                                                </a>
                                            </li>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('post-list')): ?>
                                            <li class="menu-item">
                                                <a href="<?php echo e(route('posts.index')); ?>" class="menu-link">
                                                    <div data-i18n="Blog List">Blog List</div>
                                                </a>
                                            </li>
                                        <?php endif; ?>


                                    </ul>
                                </li>

                            <?php endif; ?>
                            <li class="menu-item">
                                <a href="<?php echo e(url('/suspend-requests')); ?>" class="menu-link">
                                    <i class="menu-icon tf-icons ti ti-users"></i>
                                    <div data-i18n="Suspend Requests">Suspend Requests</div>
                                </a>
                            </li>
                            <li class="menu-item">
                                <a href="<?php echo e(url('/activity-logs')); ?>" class="menu-link">
                                    <i class="menu-icon tf-icons ti ti-users"></i>
                                    <div data-i18n="Activity Logs">Activity Logs</div>
                                </a>
                            </li>
                            
                        </ul>
                    </li>
                    <li class="menu-item">

                        <?php if($user_id == '7'): ?>
                            <a href="<?php echo e(url('/chat?reciverId=17')); ?>" class="menu-link">
                        <?php else: ?>
                                <a href="<?php echo e(url('/chat?reciverId=7')); ?>" class="menu-link">
                            <?php endif; ?>
                                <i class="menu-icon tf-icons ti ti-messages"></i>
                                <div data-i18n="Chat">Chat</div>
                            </a>

                            
                    </li>


                <?php endif; ?>
        <?php if (\Illuminate\Support\Facades\Blade::check('hasrole', 'Admin')): ?>
        <!-- Forms -->

        <li class="menu-item">
            <a href="javascript:void(0);" class="menu-link menu-toggle">
                <i class="menu-icon tf-icons ti ti-forms"></i>
                <div data-i18n="Role Permission">Role Permission</div>
            </a>
            <ul class="menu-sub">
                <li class="menu-item">
                    <a href="<?php echo e(url('/users')); ?>" class="menu-link">
                        <i class="menu-icon tf-icons ti ti-toggle-left"></i>
                        <div data-i18n="Users">Users</div>
                    </a>

                </li>
                <li class="menu-item">
                    <a href="<?php echo e(url('/roles')); ?>" class="menu-link">
                        <i class="menu-icon tf-icons ti ti-layout-navbar"></i>
                        <div data-i18n="Role">Role</div>
                    </a>

                </li>
                <li class="menu-item">
                    <a href="<?php echo e(url('/permissions')); ?>" class="menu-link">
                        <i class="menu-icon tf-icons ti ti-text-wrap-disabled"></i>
                        <div data-i18n="Permission">Permission</div>
                    </a>

                </li>
                <li class="menu-item">
                    <a href="<?php echo e(url('/media')); ?>" class="menu-link">
                        <i class="menu-icon tf-icons ti ti-checkbox"></i>
                        <div data-i18n="Media">Media</div>
                    </a>
                </li>
            </ul>
        </li>
        <?php endif; ?>


        </ul>
    </div>
</aside>
<!-- / Menu --><?php /**PATH C:\laragon\www\NHG-backup\resources\views/layouts/partials/sidebar.blade.php ENDPATH**/ ?>