<?php $__env->startSection('content'); ?>

    <div class="row">
        <div class="col-sm-12 col-md-12">
            <div class="card ">
                <div class="card-header py-2">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="fs-17 font-weight-600 mb-0">List of Suspend Request</h6>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table display table-bordered table-striped table-hover custom-table" id="category">
                            <thead>
                                <tr>
                                    <th>SL</th>
                                    <th>Date</th>
                                    <th>Type</th>
                                    <th>Name</th>
                                    <th>Reason</th>
                                    <th>Status</th>
                                    <?php if(auth()->user()->can('suspend')): ?>
                                    <th>Action</th>
                                    <?php endif; ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $suspends; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $suspend): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                
                                    <tr>
                                        <td><?php echo e($loop->index + 1); ?></td>
                                        <td><?php echo e(\Carbon\Carbon::parse($suspend->created_at)->toDateString()); ?></td>
                                        <td><?php echo e($suspend->type); ?></td>
                                        <td>
                                            <?php if($suspend->type =='Aggregators'): ?>
                                                
                                               <?php echo e($suspend->company_name); ?>

                                                
                                            <?php elseif($suspend->type =='Cooks'): ?>
                                                <?php echo e($suspend->first_name); ?>

                                                
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($suspend->reason); ?></td>
                                        <td><?php echo e($suspend->status); ?></td>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('suspend')): ?>
                                        <td class="form-inline">
                                            <a href="<?php echo e(url('suspend-approved', $suspend->id)); ?>" class="btn btn-success btn-xs" title="Approve" style="margin-right:3px">Approve</a>
                                            <a href="<?php echo e(url('suspend-declined', $suspend->id)); ?>" class="btn btn-warning btn-xs" title="Decline" style="margin-right:3px">Decline</a>
                                            <a href="<?php echo e(url('suspend-delete', $suspend->id)); ?>" class="btn btn-danger btn-xs" id="delete" title="Delete" style="margin-right:3px">Delete</a>
                                        </td>
                                        <?php endif; ?>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('custom-js'); ?>
    <script>
        $(document).ready(function() {
            $("#category").DataTable();
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\NHG-backup\resources\views/suspend/index.blade.php ENDPATH**/ ?>